/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAlarmsRequest> {
    private final List<String> alarmNames;
    private final String alarmNamePrefix;
    private final String stateValue;
    private final String actionPrefix;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    public String alarmNamePrefix() {
        return this.alarmNamePrefix;
    }

    public StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public String stateValueString() {
        return this.stateValue;
    }

    public String actionPrefix() {
        return this.actionPrefix;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmNames() == null ? 0 : this.alarmNames().hashCode());
        hashCode = 31 * hashCode + (this.alarmNamePrefix() == null ? 0 : this.alarmNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.stateValueString() == null ? 0 : this.stateValueString().hashCode());
        hashCode = 31 * hashCode + (this.actionPrefix() == null ? 0 : this.actionPrefix().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest)((Object)obj);
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        if (other.alarmNames() != null && !other.alarmNames().equals(this.alarmNames())) {
            return false;
        }
        if (other.alarmNamePrefix() == null ^ this.alarmNamePrefix() == null) {
            return false;
        }
        if (other.alarmNamePrefix() != null && !other.alarmNamePrefix().equals(this.alarmNamePrefix())) {
            return false;
        }
        if (other.stateValueString() == null ^ this.stateValueString() == null) {
            return false;
        }
        if (other.stateValueString() != null && !other.stateValueString().equals(this.stateValueString())) {
            return false;
        }
        if (other.actionPrefix() == null ^ this.actionPrefix() == null) {
            return false;
        }
        if (other.actionPrefix() != null && !other.actionPrefix().equals(this.actionPrefix())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmNames() != null) {
            sb.append("AlarmNames: ").append(this.alarmNames()).append(",");
        }
        if (this.alarmNamePrefix() != null) {
            sb.append("AlarmNamePrefix: ").append(this.alarmNamePrefix()).append(",");
        }
        if (this.stateValueString() != null) {
            sb.append("StateValue: ").append(this.stateValueString()).append(",");
        }
        if (this.actionPrefix() != null) {
            sb.append("ActionPrefix: ").append(this.actionPrefix()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmNames": {
                return Optional.of(clazz.cast(this.alarmNames()));
            }
            case "AlarmNamePrefix": {
                return Optional.of(clazz.cast(this.alarmNamePrefix()));
            }
            case "StateValue": {
                return Optional.of(clazz.cast(this.stateValueString()));
            }
            case "ActionPrefix": {
                return Optional.of(clazz.cast(this.actionPrefix()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> alarmNames;
        private String alarmNamePrefix;
        private String stateValue;
        private String actionPrefix;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            this.alarmNames(model.alarmNames);
            this.alarmNamePrefix(model.alarmNamePrefix);
            this.stateValue(model.stateValue);
            this.actionPrefix(model.actionPrefix);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        public final String getAlarmNamePrefix() {
            return this.alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getActionPrefix() {
            return this.actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);

        public Builder alarmNamePrefix(String var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder actionPrefix(String var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);
    }
}

