/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetAlarmStateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetAlarmStateRequest> {
    private final String alarmName;
    private final String stateValue;
    private final String stateReason;
    private final String stateReasonData;

    private SetAlarmStateRequest(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public String stateValueString() {
        return this.stateValue;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String stateReasonData() {
        return this.stateReasonData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmName() == null ? 0 : this.alarmName().hashCode());
        hashCode = 31 * hashCode + (this.stateValueString() == null ? 0 : this.stateValueString().hashCode());
        hashCode = 31 * hashCode + (this.stateReason() == null ? 0 : this.stateReason().hashCode());
        hashCode = 31 * hashCode + (this.stateReasonData() == null ? 0 : this.stateReasonData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetAlarmStateRequest)) {
            return false;
        }
        SetAlarmStateRequest other = (SetAlarmStateRequest)((Object)obj);
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.stateValueString() == null ^ this.stateValueString() == null) {
            return false;
        }
        if (other.stateValueString() != null && !other.stateValueString().equals(this.stateValueString())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.stateReasonData() == null ^ this.stateReasonData() == null) {
            return false;
        }
        return other.stateReasonData() == null || other.stateReasonData().equals(this.stateReasonData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.stateValueString() != null) {
            sb.append("StateValue: ").append(this.stateValueString()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.stateReasonData() != null) {
            sb.append("StateReasonData: ").append(this.stateReasonData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.of(clazz.cast(this.alarmName()));
            }
            case "StateValue": {
                return Optional.of(clazz.cast(this.stateValueString()));
            }
            case "StateReason": {
                return Optional.of(clazz.cast(this.stateReason()));
            }
            case "StateReasonData": {
                return Optional.of(clazz.cast(this.stateReasonData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String stateValue;
        private String stateReason;
        private String stateReasonData;

        private BuilderImpl() {
        }

        private BuilderImpl(SetAlarmStateRequest model) {
            this.alarmName(model.alarmName);
            this.stateValue(model.stateValue);
            this.stateReason(model.stateReason);
            this.stateReasonData(model.stateReasonData);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return this.stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        public SetAlarmStateRequest build() {
            return new SetAlarmStateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetAlarmStateRequest> {
        public Builder alarmName(String var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder stateReason(String var1);

        public Builder stateReasonData(String var1);
    }
}

