/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDashboardsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteDashboardsRequest.Builder, DeleteDashboardsRequest> {
    private final List<String> dashboardNames;

    private DeleteDashboardsRequest(BuilderImpl builder) {
        this.dashboardNames = builder.dashboardNames;
    }

    /**
     * <p>
     * The dashboards to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dashboards to be deleted.
     */
    public List<String> dashboardNames() {
        return dashboardNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDashboardsRequest)) {
            return false;
        }
        DeleteDashboardsRequest other = (DeleteDashboardsRequest) obj;
        return Objects.equals(dashboardNames(), other.dashboardNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dashboardNames() != null) {
            sb.append("DashboardNames: ").append(dashboardNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardNames":
            return Optional.of(clazz.cast(dashboardNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDashboardsRequest> {
        /**
         * <p>
         * The dashboards to be deleted.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(Collection<String> dashboardNames);

        /**
         * <p>
         * The dashboards to be deleted.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(String... dashboardNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> dashboardNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDashboardsRequest model) {
            dashboardNames(model.dashboardNames);
        }

        public final Collection<String> getDashboardNames() {
            return dashboardNames;
        }

        @Override
        public final Builder dashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardNames(String... dashboardNames) {
            dashboardNames(Arrays.asList(dashboardNames));
            return this;
        }

        public final void setDashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
        }

        @Override
        public DeleteDashboardsRequest build() {
            return new DeleteDashboardsRequest(this);
        }
    }
}
