/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMetricStatisticsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMetricStatisticsResponse.Builder, GetMetricStatisticsResponse> {
    private final String label;

    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    /**
     * <p>
     * A label for the specified metric.
     * </p>
     * 
     * @return A label for the specified metric.
     */
    public String label() {
        return label;
    }

    /**
     * <p>
     * The data points for the specified metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data points for the specified metric.
     */
    public List<Datapoint> datapoints() {
        return datapoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(datapoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse) obj;
        return Objects.equals(label(), other.label()) && Objects.equals(datapoints(), other.datapoints());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (label() != null) {
            sb.append("Label: ").append(label()).append(",");
        }
        if (datapoints() != null) {
            sb.append("Datapoints: ").append(datapoints()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.of(clazz.cast(label()));
        case "Datapoints":
            return Optional.of(clazz.cast(datapoints()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        /**
         * <p>
         * A label for the specified metric.
         * </p>
         * 
         * @param label
         *        A label for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Collection<Datapoint> datapoints);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Datapoint... datapoints);
    }

    static final class BuilderImpl implements Builder {
        private String label;

        private List<Datapoint> datapoints;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            label(model.label);
            datapoints(model.datapoints);
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Datapoint.Builder> getDatapoints() {
            return datapoints != null ? datapoints.stream().map(Datapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint... datapoints) {
            datapoints(Arrays.asList(datapoints));
            return this;
        }

        public final void setDatapoints(Collection<Datapoint.BuilderImpl> datapoints) {
            this.datapoints = DatapointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }
    }
}
