/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeAlarmHistoryResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmHistoryResponseUnmarshaller implements
        Unmarshaller<DescribeAlarmHistoryResponse, StaxUnmarshallerContext> {

    public DescribeAlarmHistoryResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeAlarmHistoryResponse.Builder describeAlarmHistoryResponse = DescribeAlarmHistoryResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<AlarmHistoryItem> alarmHistoryItems = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeAlarmHistoryResponse.alarmHistoryItems(alarmHistoryItems);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AlarmHistoryItems", targetDepth)) {
                    alarmHistoryItems = new ArrayList<AlarmHistoryItem>();
                    continue;
                }

                if (context.testExpression("AlarmHistoryItems/member", targetDepth)) {
                    alarmHistoryItems.add(AlarmHistoryItemUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeAlarmHistoryResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeAlarmHistoryResponse.alarmHistoryItems(alarmHistoryItems);
                    break;
                }
            }
        }
        return describeAlarmHistoryResponse.build();
    }

    private static final DescribeAlarmHistoryResponseUnmarshaller INSTANCE = new DescribeAlarmHistoryResponseUnmarshaller();

    public static DescribeAlarmHistoryResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
