/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeAlarmsForMetricRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmsForMetricRequestMarshaller implements
        Marshaller<Request<DescribeAlarmsForMetricRequest>, DescribeAlarmsForMetricRequest> {

    public Request<DescribeAlarmsForMetricRequest> marshall(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {

        if (describeAlarmsForMetricRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeAlarmsForMetricRequest> request = new DefaultRequest<DescribeAlarmsForMetricRequest>(
                describeAlarmsForMetricRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmsForMetric");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeAlarmsForMetricRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(describeAlarmsForMetricRequest.metricName()));
        }

        if (describeAlarmsForMetricRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(describeAlarmsForMetricRequest.namespace()));
        }

        if (describeAlarmsForMetricRequest.statisticString() != null) {
            request.addParameter("Statistic", StringUtils.fromString(describeAlarmsForMetricRequest.statisticString()));
        }

        if (describeAlarmsForMetricRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString(describeAlarmsForMetricRequest.extendedStatistic()));
        }

        java.util.List<Dimension> dimensionsList = describeAlarmsForMetricRequest.dimensions();

        if (dimensionsList != null) {
            if (!dimensionsList.isEmpty()) {
                int dimensionsListIndex = 1;

                for (Dimension dimensionsListValue : dimensionsList) {

                    if (dimensionsListValue.name() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                                StringUtils.fromString(dimensionsListValue.name()));
                    }

                    if (dimensionsListValue.value() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                                StringUtils.fromString(dimensionsListValue.value()));
                    }
                    dimensionsListIndex++;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }

        if (describeAlarmsForMetricRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger(describeAlarmsForMetricRequest.period()));
        }

        if (describeAlarmsForMetricRequest.unitString() != null) {
            request.addParameter("Unit", StringUtils.fromString(describeAlarmsForMetricRequest.unitString()));
        }

        return request;
    }

}
