/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeAlarmsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmsResponseUnmarshaller implements Unmarshaller<DescribeAlarmsResponse, StaxUnmarshallerContext> {

    public DescribeAlarmsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeAlarmsResponse.Builder describeAlarmsResponse = DescribeAlarmsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<MetricAlarm> metricAlarms = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeAlarmsResponse.metricAlarms(metricAlarms);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MetricAlarms", targetDepth)) {
                    metricAlarms = new ArrayList<MetricAlarm>();
                    continue;
                }

                if (context.testExpression("MetricAlarms/member", targetDepth)) {
                    metricAlarms.add(MetricAlarmUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeAlarmsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeAlarmsResponse.metricAlarms(metricAlarms);
                    break;
                }
            }
        }
        return describeAlarmsResponse.build();
    }

    private static final DescribeAlarmsResponseUnmarshaller INSTANCE = new DescribeAlarmsResponseUnmarshaller();

    public static DescribeAlarmsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
