/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DashboardEntry implements ToCopyableBuilder<DashboardEntry.Builder, DashboardEntry> {
    private final String dashboardName;

    private final String dashboardArn;

    private final Instant lastModified;

    private final Long size;

    private DashboardEntry(BuilderImpl builder) {
        this.dashboardName = builder.dashboardName;
        this.dashboardArn = builder.dashboardArn;
        this.lastModified = builder.lastModified;
        this.size = builder.size;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The time stamp of when the dashboard was last modified, either by an API call or through the console. This number
     * is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time stamp of when the dashboard was last modified, either by an API call or through the console.
     *         This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The size of the dashboard, in bytes.
     * </p>
     * 
     * @return The size of the dashboard, in bytes.
     */
    public Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardEntry)) {
            return false;
        }
        DashboardEntry other = (DashboardEntry) obj;
        return Objects.equals(dashboardName(), other.dashboardName()) && Objects.equals(dashboardArn(), other.dashboardArn())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(size(), other.size());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dashboardName() != null) {
            sb.append("DashboardName: ").append(dashboardName()).append(",");
        }
        if (dashboardArn() != null) {
            sb.append("DashboardArn: ").append(dashboardArn()).append(",");
        }
        if (lastModified() != null) {
            sb.append("LastModified: ").append(lastModified()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardName":
            return Optional.of(clazz.cast(dashboardName()));
        case "DashboardArn":
            return Optional.of(clazz.cast(dashboardArn()));
        case "LastModified":
            return Optional.of(clazz.cast(lastModified()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DashboardEntry> {
        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The time stamp of when the dashboard was last modified, either by an API call or through the console. This
         * number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param lastModified
         *        The time stamp of when the dashboard was last modified, either by an API call or through the console.
         *        This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The size of the dashboard, in bytes.
         * </p>
         * 
         * @param size
         *        The size of the dashboard, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    static final class BuilderImpl implements Builder {
        private String dashboardName;

        private String dashboardArn;

        private Instant lastModified;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardEntry model) {
            dashboardName(model.dashboardName);
            dashboardArn(model.dashboardArn);
            lastModified(model.lastModified);
            size(model.size);
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public DashboardEntry build() {
            return new DashboardEntry(this);
        }
    }
}
