/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmHistoryRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAlarmHistoryRequest.Builder, DescribeAlarmHistoryRequest> {
    private final String alarmName;

    private final String historyItemType;

    private final Instant startDate;

    private final Instant endDate;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The type of alarm histories to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeString}.
     * </p>
     * 
     * @return The type of alarm histories to retrieve.
     * @see HistoryItemType
     */
    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(historyItemType);
    }

    /**
     * <p>
     * The type of alarm histories to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeString}.
     * </p>
     * 
     * @return The type of alarm histories to retrieve.
     * @see HistoryItemType
     */
    public String historyItemTypeString() {
        return historyItemType;
    }

    /**
     * <p>
     * The starting date to retrieve alarm history.
     * </p>
     * 
     * @return The starting date to retrieve alarm history.
     */
    public Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date to retrieve alarm history.
     * </p>
     * 
     * @return The ending date to retrieve alarm history.
     */
    public Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The maximum number of alarm history records to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm history records to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(historyItemTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest) obj;
        return Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(historyItemTypeString(), other.historyItemTypeString())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (historyItemTypeString() != null) {
            sb.append("HistoryItemType: ").append(historyItemTypeString()).append(",");
        }
        if (startDate() != null) {
            sb.append("StartDate: ").append(startDate()).append(",");
        }
        if (endDate() != null) {
            sb.append("EndDate: ").append(endDate()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.of(clazz.cast(alarmName()));
        case "HistoryItemType":
            return Optional.of(clazz.cast(historyItemTypeString()));
        case "StartDate":
            return Optional.of(clazz.cast(startDate()));
        case "EndDate":
            return Optional.of(clazz.cast(endDate()));
        case "MaxRecords":
            return Optional.of(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(String historyItemType);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(HistoryItemType historyItemType);

        /**
         * <p>
         * The starting date to retrieve alarm history.
         * </p>
         * 
         * @param startDate
         *        The starting date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The ending date to retrieve alarm history.
         * </p>
         * 
         * @param endDate
         *        The ending date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The maximum number of alarm history records to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm history records to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String historyItemType;

        private Instant startDate;

        private Instant endDate;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            alarmName(model.alarmName);
            historyItemType(model.historyItemType);
            startDate(model.startDate);
            endDate(model.endDate);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemType() {
            return historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }
    }
}
