/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAlarmsRequest.Builder, DescribeAlarmsRequest> {
    private final List<String> alarmNames;

    private final String alarmNamePrefix;

    private final String stateValue;

    private final String actionPrefix;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the alarms.
     */
    public List<String> alarmNames() {
        return alarmNames;
    }

    /**
     * <p>
     * The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     * </p>
     * 
     * @return The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     */
    public String alarmNamePrefix() {
        return alarmNamePrefix;
    }

    /**
     * <p>
     * The state value to be used in matching alarms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueString}.
     * </p>
     * 
     * @return The state value to be used in matching alarms.
     * @see StateValue
     */
    public StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The state value to be used in matching alarms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueString}.
     * </p>
     * 
     * @return The state value to be used in matching alarms.
     * @see StateValue
     */
    public String stateValueString() {
        return stateValue;
    }

    /**
     * <p>
     * The action name prefix.
     * </p>
     * 
     * @return The action name prefix.
     */
    public String actionPrefix() {
        return actionPrefix;
    }

    /**
     * <p>
     * The maximum number of alarm descriptions to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm descriptions to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmNames());
        hashCode = 31 * hashCode + Objects.hashCode(alarmNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueString());
        hashCode = 31 * hashCode + Objects.hashCode(actionPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest) obj;
        return Objects.equals(alarmNames(), other.alarmNames()) && Objects.equals(alarmNamePrefix(), other.alarmNamePrefix())
                && Objects.equals(stateValueString(), other.stateValueString())
                && Objects.equals(actionPrefix(), other.actionPrefix()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (alarmNames() != null) {
            sb.append("AlarmNames: ").append(alarmNames()).append(",");
        }
        if (alarmNamePrefix() != null) {
            sb.append("AlarmNamePrefix: ").append(alarmNamePrefix()).append(",");
        }
        if (stateValueString() != null) {
            sb.append("StateValue: ").append(stateValueString()).append(",");
        }
        if (actionPrefix() != null) {
            sb.append("ActionPrefix: ").append(actionPrefix()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmNames":
            return Optional.of(clazz.cast(alarmNames()));
        case "AlarmNamePrefix":
            return Optional.of(clazz.cast(alarmNamePrefix()));
        case "StateValue":
            return Optional.of(clazz.cast(stateValueString()));
        case "ActionPrefix":
            return Optional.of(clazz.cast(actionPrefix()));
        case "MaxRecords":
            return Optional.of(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, DescribeAlarmsRequest> {
        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);

        /**
         * <p>
         * The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * </p>
         * 
         * @param alarmNamePrefix
         *        The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNamePrefix(String alarmNamePrefix);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The action name prefix.
         * </p>
         * 
         * @param actionPrefix
         *        The action name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPrefix(String actionPrefix);

        /**
         * <p>
         * The maximum number of alarm descriptions to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm descriptions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> alarmNames;

        private String alarmNamePrefix;

        private String stateValue;

        private String actionPrefix;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            alarmNames(model.alarmNames);
            alarmNamePrefix(model.alarmNamePrefix);
            stateValue(model.stateValue);
            actionPrefix(model.actionPrefix);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            return alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        public final String getAlarmNamePrefix() {
            return alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getActionPrefix() {
            return actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }
    }
}
