/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDashboardsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<ListDashboardsRequest.Builder, ListDashboardsRequest> {
    private final String dashboardNamePrefix;

    private final String nextToken;

    private ListDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNamePrefix = builder.dashboardNamePrefix;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * If you specify this parameter, only the dashboards with names starting with the specified string are listed. The
     * maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
     * </p>
     * 
     * @return If you specify this parameter, only the dashboards with names starting with the specified string are
     *         listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
     */
    public String dashboardNamePrefix() {
        return dashboardNamePrefix;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsRequest)) {
            return false;
        }
        ListDashboardsRequest other = (ListDashboardsRequest) obj;
        return Objects.equals(dashboardNamePrefix(), other.dashboardNamePrefix())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dashboardNamePrefix() != null) {
            sb.append("DashboardNamePrefix: ").append(dashboardNamePrefix()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardNamePrefix":
            return Optional.of(clazz.cast(dashboardNamePrefix()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, ListDashboardsRequest> {
        /**
         * <p>
         * If you specify this parameter, only the dashboards with names starting with the specified string are listed.
         * The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
         * </p>
         * 
         * @param dashboardNamePrefix
         *        If you specify this parameter, only the dashboards with names starting with the specified string are
         *        listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNamePrefix(String dashboardNamePrefix);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String dashboardNamePrefix;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsRequest model) {
            dashboardNamePrefix(model.dashboardNamePrefix);
            nextToken(model.nextToken);
        }

        public final String getDashboardNamePrefix() {
            return dashboardNamePrefix;
        }

        @Override
        public final Builder dashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
            return this;
        }

        public final void setDashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDashboardsRequest build() {
            return new ListDashboardsRequest(this);
        }
    }
}
