/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutMetricAlarmRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutMetricAlarmRequest.Builder, PutMetricAlarmRequest> {
    private final String alarmName;

    private final String alarmDescription;

    private final Boolean actionsEnabled;

    private final List<String> okActions;

    private final List<String> alarmActions;

    private final List<String> insufficientDataActions;

    private final String metricName;

    private final String namespace;

    private final String statistic;

    private final String extendedStatistic;

    private final List<Dimension> dimensions;

    private final Integer period;

    private final String unit;

    private final Integer evaluationPeriods;

    private final Double threshold;

    private final String comparisonOperator;

    private final String treatMissingData;

    private final String evaluateLowSampleCountPercentile;

    private PutMetricAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.alarmDescription = builder.alarmDescription;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
    }

    /**
     * <p>
     * The name for the alarm. This name must be unique within the AWS account.
     * </p>
     * 
     * @return The name for the alarm. This name must be unique within the AWS account.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The description for the alarm.
     * </p>
     * 
     * @return The description for the alarm.
     */
    public String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state.
     */
    public Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action
     * is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
     *         action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> okActions() {
        return okActions;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
     * action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
     * state. Each action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     * arn:aws:automate:<i>region</i>:ec2:recover
     * </p>
     * <p>
     * Valid Values (for use with IAM roles):
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any
     *         other state. Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
     *         arn:aws:automate:<i>region</i>:ec2:recover
     *         </p>
     *         <p>
     *         Valid Values (for use with IAM roles):
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
     *         arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
     */
    public List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * <p>
     * The name for the metric associated with the alarm.
     * </p>
     * 
     * @return The name for the metric associated with the alarm.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace for the metric associated with the alarm.
     * </p>
     * 
     * @return The namespace for the metric associated with the alarm.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticString}.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public Statistic statistic() {
        return Statistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticString}.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public String statisticString() {
        return statistic;
    }

    /**
     * <p>
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     * </p>
     * 
     * @return The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     */
    public String extendedStatistic() {
        return extendedStatistic;
    }

    /**
     * <p>
     * The dimensions for the metric associated with the alarm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dimensions for the metric associated with the alarm.
     */
    public List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The period, in seconds, over which the specified statistic is applied. Valid values are 10, 30, and any multiple
     * of 60.
     * </p>
     * <p>
     * Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with a
     * <code>StorageResolution</code> of 1. If you specify a Period of 10 or 30 for a metric that does not have
     * sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this case,
     * it does not receive data for the attempts that do not correspond to a one-minute data resolution, and the alarm
     * may often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a high-resolution
     * alarm, which has a higher charge than other alarms. For more information about pricing, see <a
     * href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
     * </p>
     * <p>
     * An alarm's total current evaluation period can be no longer than one day, so <code>Period</code> multiplied by
     * <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.
     * </p>
     * 
     * @return The period, in seconds, over which the specified statistic is applied. Valid values are 10, 30, and any
     *         multiple of 60.</p>
     *         <p>
     *         Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with a
     *         <code>StorageResolution</code> of 1. If you specify a Period of 10 or 30 for a metric that does not have
     *         sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In
     *         this case, it does not receive data for the attempts that do not correspond to a one-minute data
     *         resolution, and the alarm may often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets
     *         this alarm as a high-resolution alarm, which has a higher charge than other alarms. For more information
     *         about pricing, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
     *         </p>
     *         <p>
     *         An alarm's total current evaluation period can be no longer than one day, so <code>Period</code>
     *         multiplied by <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
     * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also
     * specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data
     * points that specify a unit of measure, such as Percent, are aggregated separately.
     * </p>
     * <p>
     * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch alarm
     * can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitString}.
     * </p>
     * 
     * @return The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
     *         Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces.
     *         You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to
     *         your data. Metric data points that specify a unit of measure, such as Percent, are aggregated
     *         separately.</p>
     *         <p>
     *         If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch
     *         alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * @see StandardUnit
     */
    public StandardUnit unit() {
        return StandardUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
     * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also
     * specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data
     * points that specify a unit of measure, such as Percent, are aggregated separately.
     * </p>
     * <p>
     * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch alarm
     * can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitString}.
     * </p>
     * 
     * @return The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
     *         Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces.
     *         You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to
     *         your data. Metric data points that specify a unit of measure, such as Percent, are aggregated
     *         separately.</p>
     *         <p>
     *         If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch
     *         alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
     * @see StandardUnit
     */
    public String unitString() {
        return unit;
    }

    /**
     * <p>
     * The number of periods over which data is compared to the specified threshold. An alarm's total current evaluation
     * period can be no longer than one day, so this number multiplied by <code>Period</code> cannot be more than 86,400
     * seconds.
     * </p>
     * 
     * @return The number of periods over which data is compared to the specified threshold. An alarm's total current
     *         evaluation period can be no longer than one day, so this number multiplied by <code>Period</code> cannot
     *         be more than 86,400 seconds.
     */
    public Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * The value against which the specified statistic is compared.
     * </p>
     * 
     * @return The value against which the specified statistic is compared.
     */
    public Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public String comparisonOperatorString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the default
     * behavior of <code>missing</code> is used. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
     * >Configuring How CloudWatch Alarms Treats Missing Data</a>.
     * </p>
     * <p>
     * Valid Values: <code>breaching | notBreaching | ignore | missing</code>
     * </p>
     * 
     * @return Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
     *         default behavior of <code>missing</code> is used. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
     *         >Configuring How CloudWatch Alarms Treats Missing Data</a>.</p>
     *         <p>
     *         Valid Values: <code>breaching | notBreaching | ignore | missing</code>
     */
    public String treatMissingData() {
        return treatMissingData;
    }

    /**
     * <p>
     * Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does not change
     * during periods with too few data points to be statistically significant. If you specify <code>evaluate</code> or
     * omit this parameter, the alarm is always evaluated and possibly changes state no matter how many data points are
     * available. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
     * >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.
     * </p>
     * <p>
     * Valid Values: <code>evaluate | ignore</code>
     * </p>
     * 
     * @return Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does not
     *         change during periods with too few data points to be statistically significant. If you specify
     *         <code>evaluate</code> or omit this parameter, the alarm is always evaluated and possibly changes state no
     *         matter how many data points are available. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
     *         >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p>
     *         <p>
     *         Valid Values: <code>evaluate | ignore</code>
     */
    public String evaluateLowSampleCountPercentile() {
        return evaluateLowSampleCountPercentile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(okActions());
        hashCode = 31 * hashCode + Objects.hashCode(alarmActions());
        hashCode = 31 * hashCode + Objects.hashCode(insufficientDataActions());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(statisticString());
        hashCode = 31 * hashCode + Objects.hashCode(extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(unitString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(evaluateLowSampleCountPercentile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricAlarmRequest)) {
            return false;
        }
        PutMetricAlarmRequest other = (PutMetricAlarmRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(alarmDescription(), other.alarmDescription())
                && Objects.equals(actionsEnabled(), other.actionsEnabled()) && Objects.equals(okActions(), other.okActions())
                && Objects.equals(alarmActions(), other.alarmActions())
                && Objects.equals(insufficientDataActions(), other.insufficientDataActions())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(statisticString(), other.statisticString())
                && Objects.equals(extendedStatistic(), other.extendedStatistic())
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(period(), other.period())
                && Objects.equals(unitString(), other.unitString())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(comparisonOperatorString(), other.comparisonOperatorString())
                && Objects.equals(treatMissingData(), other.treatMissingData())
                && Objects.equals(evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (alarmDescription() != null) {
            sb.append("AlarmDescription: ").append(alarmDescription()).append(",");
        }
        if (actionsEnabled() != null) {
            sb.append("ActionsEnabled: ").append(actionsEnabled()).append(",");
        }
        if (okActions() != null) {
            sb.append("OKActions: ").append(okActions()).append(",");
        }
        if (alarmActions() != null) {
            sb.append("AlarmActions: ").append(alarmActions()).append(",");
        }
        if (insufficientDataActions() != null) {
            sb.append("InsufficientDataActions: ").append(insufficientDataActions()).append(",");
        }
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (statisticString() != null) {
            sb.append("Statistic: ").append(statisticString()).append(",");
        }
        if (extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(extendedStatistic()).append(",");
        }
        if (dimensions() != null) {
            sb.append("Dimensions: ").append(dimensions()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (unitString() != null) {
            sb.append("Unit: ").append(unitString()).append(",");
        }
        if (evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(evaluationPeriods()).append(",");
        }
        if (threshold() != null) {
            sb.append("Threshold: ").append(threshold()).append(",");
        }
        if (comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(comparisonOperatorString()).append(",");
        }
        if (treatMissingData() != null) {
            sb.append("TreatMissingData: ").append(treatMissingData()).append(",");
        }
        if (evaluateLowSampleCountPercentile() != null) {
            sb.append("EvaluateLowSampleCountPercentile: ").append(evaluateLowSampleCountPercentile()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.of(clazz.cast(alarmName()));
        case "AlarmDescription":
            return Optional.of(clazz.cast(alarmDescription()));
        case "ActionsEnabled":
            return Optional.of(clazz.cast(actionsEnabled()));
        case "OKActions":
            return Optional.of(clazz.cast(okActions()));
        case "AlarmActions":
            return Optional.of(clazz.cast(alarmActions()));
        case "InsufficientDataActions":
            return Optional.of(clazz.cast(insufficientDataActions()));
        case "MetricName":
            return Optional.of(clazz.cast(metricName()));
        case "Namespace":
            return Optional.of(clazz.cast(namespace()));
        case "Statistic":
            return Optional.of(clazz.cast(statisticString()));
        case "ExtendedStatistic":
            return Optional.of(clazz.cast(extendedStatistic()));
        case "Dimensions":
            return Optional.of(clazz.cast(dimensions()));
        case "Period":
            return Optional.of(clazz.cast(period()));
        case "Unit":
            return Optional.of(clazz.cast(unitString()));
        case "EvaluationPeriods":
            return Optional.of(clazz.cast(evaluationPeriods()));
        case "Threshold":
            return Optional.of(clazz.cast(threshold()));
        case "ComparisonOperator":
            return Optional.of(clazz.cast(comparisonOperatorString()));
        case "TreatMissingData":
            return Optional.of(clazz.cast(treatMissingData()));
        case "EvaluateLowSampleCountPercentile":
            return Optional.of(clazz.cast(evaluateLowSampleCountPercentile()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, PutMetricAlarmRequest> {
        /**
         * <p>
         * The name for the alarm. This name must be unique within the AWS account.
         * </p>
         * 
         * @param alarmName
         *        The name for the alarm. This name must be unique within the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The description for the alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         * arn:aws:automate:<i>region</i>:ec2:recover
         * </p>
         * <p>
         * Valid Values (for use with IAM roles):
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         * arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: arn:aws:automate:<i>region</i>:ec2:stop | arn:aws:automate:<i>region</i>:ec2:terminate |
         *        arn:aws:automate:<i>region</i>:ec2:recover
         *        </p>
         *        <p>
         *        Valid Values (for use with IAM roles):
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Stop/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Terminate/1.0 |
         *        arn:aws:swf:us-east-1:{<i>customer-account</i>}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The name for the metric associated with the alarm.
         * </p>
         * 
         * @param metricName
         *        The name for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace for the metric associated with the alarm.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistic
         *        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and
         *        p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistic(String extendedStatistic);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The period, in seconds, over which the specified statistic is applied. Valid values are 10, 30, and any
         * multiple of 60.
         * </p>
         * <p>
         * Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with a
         * <code>StorageResolution</code> of 1. If you specify a Period of 10 or 30 for a metric that does not have
         * sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this
         * case, it does not receive data for the attempts that do not correspond to a one-minute data resolution, and
         * the alarm may often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a
         * high-resolution alarm, which has a higher charge than other alarms. For more information about pricing, see
         * <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
         * </p>
         * <p>
         * An alarm's total current evaluation period can be no longer than one day, so <code>Period</code> multiplied
         * by <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.
         * </p>
         * 
         * @param period
         *        The period, in seconds, over which the specified statistic is applied. Valid values are 10, 30, and
         *        any multiple of 60.</p>
         *        <p>
         *        Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with
         *        a <code>StorageResolution</code> of 1. If you specify a Period of 10 or 30 for a metric that does not
         *        have sub-minute resolution, the alarm still attempts to gather data at the period rate that you
         *        specify. In this case, it does not receive data for the attempts that do not correspond to a
         *        one-minute data resolution, and the alarm may often lapse into INSUFFICENT_DATA status. Specifying 10
         *        or 30 also sets this alarm as a high-resolution alarm, which has a higher charge than other alarms.
         *        For more information about pricing, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon
         *        CloudWatch Pricing</a>.
         *        </p>
         *        <p>
         *        An alarm's total current evaluation period can be no longer than one day, so <code>Period</code>
         *        multiplied by <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
         * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can
         * also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data.
         * Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
         * </p>
         * <p>
         * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch
         * alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
         *        Bytes because NetworkIn tracks the number of bytes that an instance receives on all network
         *        interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual
         *        meaning to your data. Metric data points that specify a unit of measure, such as Percent, are
         *        aggregated separately.</p>
         *        <p>
         *        If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the
         *        CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes
         * because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can
         * also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data.
         * Metric data points that specify a unit of measure, such as Percent, are aggregated separately.
         * </p>
         * <p>
         * If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the CloudWatch
         * alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are
         *        Bytes because NetworkIn tracks the number of bytes that an instance receives on all network
         *        interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual
         *        meaning to your data. Metric data points that specify a unit of measure, such as Percent, are
         *        aggregated separately.</p>
         *        <p>
         *        If you specify a unit, you must use a unit that is appropriate for the metric. Otherwise, the
         *        CloudWatch alarm can get stuck in the <code>INSUFFICIENT DATA</code> state.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);

        /**
         * <p>
         * The number of periods over which data is compared to the specified threshold. An alarm's total current
         * evaluation period can be no longer than one day, so this number multiplied by <code>Period</code> cannot be
         * more than 86,400 seconds.
         * </p>
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold. An alarm's total current
         *        evaluation period can be no longer than one day, so this number multiplied by <code>Period</code>
         *        cannot be more than 86,400 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * The value against which the specified statistic is compared.
         * </p>
         * 
         * @param threshold
         *        The value against which the specified statistic is compared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
         * default behavior of <code>missing</code> is used. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
         * >Configuring How CloudWatch Alarms Treats Missing Data</a>.
         * </p>
         * <p>
         * Valid Values: <code>breaching | notBreaching | ignore | missing</code>
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the
         *        default behavior of <code>missing</code> is used. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data"
         *        >Configuring How CloudWatch Alarms Treats Missing Data</a>.</p>
         *        <p>
         *        Valid Values: <code>breaching | notBreaching | ignore | missing</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * <p>
         * Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does not
         * change during periods with too few data points to be statistically significant. If you specify
         * <code>evaluate</code> or omit this parameter, the alarm is always evaluated and possibly changes state no
         * matter how many data points are available. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
         * >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.
         * </p>
         * <p>
         * Valid Values: <code>evaluate | ignore</code>
         * </p>
         * 
         * @param evaluateLowSampleCountPercentile
         *        Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does
         *        not change during periods with too few data points to be statistically significant. If you specify
         *        <code>evaluate</code> or omit this parameter, the alarm is always evaluated and possibly changes state
         *        no matter how many data points are available. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples"
         *        >Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p>
         *        <p>
         *        Valid Values: <code>evaluate | ignore</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String alarmDescription;

        private Boolean actionsEnabled;

        private List<String> okActions;

        private List<String> alarmActions;

        private List<String> insufficientDataActions;

        private String metricName;

        private String namespace;

        private String statistic;

        private String extendedStatistic;

        private List<Dimension> dimensions;

        private Integer period;

        private String unit;

        private Integer evaluationPeriods;

        private Double threshold;

        private String comparisonOperator;

        private String treatMissingData;

        private String evaluateLowSampleCountPercentile;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricAlarmRequest model) {
            alarmName(model.alarmName);
            alarmDescription(model.alarmDescription);
            actionsEnabled(model.actionsEnabled);
            okActions(model.okActions);
            alarmActions(model.alarmActions);
            insufficientDataActions(model.insufficientDataActions);
            metricName(model.metricName);
            namespace(model.namespace);
            statistic(model.statistic);
            extendedStatistic(model.extendedStatistic);
            dimensions(model.dimensions);
            period(model.period);
            unit(model.unit);
            evaluationPeriods(model.evaluationPeriods);
            threshold(model.threshold);
            comparisonOperator(model.comparisonOperator);
            treatMissingData(model.treatMissingData);
            evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getOKActions() {
            return okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOKActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        public final Collection<String> getAlarmActions() {
            return alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        public final Collection<String> getInsufficientDataActions() {
            return insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getExtendedStatistic() {
            return extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return dimensions != null ? dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutMetricAlarmRequest build() {
            return new PutMetricAlarmRequest(this);
        }
    }
}
