/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DeleteDashboardsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteDashboardsRequestMarshaller implements Marshaller<Request<DeleteDashboardsRequest>, DeleteDashboardsRequest> {

    public Request<DeleteDashboardsRequest> marshall(DeleteDashboardsRequest deleteDashboardsRequest) {

        if (deleteDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteDashboardsRequest> request = new DefaultRequest<DeleteDashboardsRequest>(deleteDashboardsRequest,
                "CloudWatchClient");
        request.addParameter("Action", "DeleteDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> dashboardNamesList = deleteDashboardsRequest.dashboardNames();

        if (dashboardNamesList != null) {
            if (!dashboardNamesList.isEmpty()) {
                int dashboardNamesListIndex = 1;

                for (String dashboardNamesListValue : dashboardNamesList) {
                    if (dashboardNamesListValue != null) {
                        request.addParameter("DashboardNames.member." + dashboardNamesListIndex,
                                StringUtils.fromString(dashboardNamesListValue));
                    }
                    dashboardNamesListIndex++;
                }
            } else {
                request.addParameter("DashboardNames", "");
            }
        }

        return request;
    }

}
