/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetMetricStatisticsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMetricStatisticsResponseUnmarshaller implements
        Unmarshaller<GetMetricStatisticsResponse, StaxUnmarshallerContext> {

    public GetMetricStatisticsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetMetricStatisticsResponse.Builder getMetricStatisticsResponse = GetMetricStatisticsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Datapoint> datapoints = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getMetricStatisticsResponse.datapoints(datapoints);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Label", targetDepth)) {
                    getMetricStatisticsResponse.label(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Datapoints", targetDepth)) {
                    datapoints = new ArrayList<Datapoint>();
                    continue;
                }

                if (context.testExpression("Datapoints/member", targetDepth)) {
                    datapoints.add(DatapointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getMetricStatisticsResponse.datapoints(datapoints);
                    break;
                }
            }
        }
        return getMetricStatisticsResponse.build();
    }

    private static final GetMetricStatisticsResponseUnmarshaller INSTANCE = new GetMetricStatisticsResponseUnmarshaller();

    public static GetMetricStatisticsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
