/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListDashboardsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListDashboardsResponseUnmarshaller implements Unmarshaller<ListDashboardsResponse, StaxUnmarshallerContext> {

    public ListDashboardsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListDashboardsResponse.Builder listDashboardsResponse = ListDashboardsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<DashboardEntry> dashboardEntries = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listDashboardsResponse.dashboardEntries(dashboardEntries);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DashboardEntries", targetDepth)) {
                    dashboardEntries = new ArrayList<DashboardEntry>();
                    continue;
                }

                if (context.testExpression("DashboardEntries/member", targetDepth)) {
                    dashboardEntries.add(DashboardEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listDashboardsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listDashboardsResponse.dashboardEntries(dashboardEntries);
                    break;
                }
            }
        }
        return listDashboardsResponse.build();
    }

    private static final ListDashboardsResponseUnmarshaller INSTANCE = new ListDashboardsResponseUnmarshaller();

    public static ListDashboardsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
