/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAlarmHistoryResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmHistoryResponse.Builder, DescribeAlarmHistoryResponse> {
    private final List<AlarmHistoryItem> alarmHistoryItems;

    private final String nextToken;

    private DescribeAlarmHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.alarmHistoryItems = builder.alarmHistoryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The alarm histories, in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The alarm histories, in JSON format.
     */
    public List<AlarmHistoryItem> alarmHistoryItems() {
        return alarmHistoryItems;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmHistoryItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryResponse)) {
            return false;
        }
        DescribeAlarmHistoryResponse other = (DescribeAlarmHistoryResponse) obj;
        return Objects.equals(alarmHistoryItems(), other.alarmHistoryItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmHistoryResponse").add("AlarmHistoryItems", alarmHistoryItems())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmHistoryItems":
            return Optional.of(clazz.cast(alarmHistoryItems()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchResponse.Builder, CopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
        /**
         * <p>
         * The alarm histories, in JSON format.
         * </p>
         * 
         * @param alarmHistoryItems
         *        The alarm histories, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems);

        /**
         * <p>
         * The alarm histories, in JSON format.
         * </p>
         * 
         * @param alarmHistoryItems
         *        The alarm histories, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmHistoryItems(AlarmHistoryItem... alarmHistoryItems);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<AlarmHistoryItem> alarmHistoryItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryResponse model) {
            alarmHistoryItems(model.alarmHistoryItems);
            nextToken(model.nextToken);
        }

        public final Collection<AlarmHistoryItem.Builder> getAlarmHistoryItems() {
            return alarmHistoryItems != null ? alarmHistoryItems.stream().map(AlarmHistoryItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(AlarmHistoryItem... alarmHistoryItems) {
            alarmHistoryItems(Arrays.asList(alarmHistoryItems));
            return this;
        }

        public final void setAlarmHistoryItems(Collection<AlarmHistoryItem.BuilderImpl> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copyFromBuilder(alarmHistoryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmHistoryResponse build() {
            return new DescribeAlarmHistoryResponse(this);
        }
    }
}
