/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * MetricAlarm StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MetricAlarmUnmarshaller implements Unmarshaller<MetricAlarm, StaxUnmarshallerContext> {

    public MetricAlarm unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricAlarm.Builder metricAlarm = MetricAlarm.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> okActions = null;
        java.util.List<String> alarmActions = null;
        java.util.List<String> insufficientDataActions = null;
        java.util.List<Dimension> dimensions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                metricAlarm.okActions(okActions);
                metricAlarm.alarmActions(alarmActions);
                metricAlarm.insufficientDataActions(insufficientDataActions);
                metricAlarm.dimensions(dimensions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AlarmName", targetDepth)) {
                    metricAlarm.alarmName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmArn", targetDepth)) {
                    metricAlarm.alarmArn(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmDescription", targetDepth)) {
                    metricAlarm.alarmDescription(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmConfigurationUpdatedTimestamp", targetDepth)) {
                    metricAlarm.alarmConfigurationUpdatedTimestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ActionsEnabled", targetDepth)) {
                    metricAlarm.actionsEnabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OKActions", targetDepth)) {
                    okActions = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("OKActions/member", targetDepth)) {
                    okActions.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmActions", targetDepth)) {
                    alarmActions = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("AlarmActions/member", targetDepth)) {
                    alarmActions.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InsufficientDataActions", targetDepth)) {
                    insufficientDataActions = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("InsufficientDataActions/member", targetDepth)) {
                    insufficientDataActions.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StateValue", targetDepth)) {
                    metricAlarm.stateValue(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StateReason", targetDepth)) {
                    metricAlarm.stateReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StateReasonData", targetDepth)) {
                    metricAlarm.stateReasonData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StateUpdatedTimestamp", targetDepth)) {
                    metricAlarm.stateUpdatedTimestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MetricName", targetDepth)) {
                    metricAlarm.metricName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Namespace", targetDepth)) {
                    metricAlarm.namespace(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Statistic", targetDepth)) {
                    metricAlarm.statistic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExtendedStatistic", targetDepth)) {
                    metricAlarm.extendedStatistic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Dimensions", targetDepth)) {
                    dimensions = new ArrayList<Dimension>();
                    continue;
                }

                if (context.testExpression("Dimensions/member", targetDepth)) {
                    dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Period", targetDepth)) {
                    metricAlarm.period(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Unit", targetDepth)) {
                    metricAlarm.unit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EvaluationPeriods", targetDepth)) {
                    metricAlarm.evaluationPeriods(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Threshold", targetDepth)) {
                    metricAlarm.threshold(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ComparisonOperator", targetDepth)) {
                    metricAlarm.comparisonOperator(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TreatMissingData", targetDepth)) {
                    metricAlarm.treatMissingData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EvaluateLowSampleCountPercentile", targetDepth)) {
                    metricAlarm.evaluateLowSampleCountPercentile(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    metricAlarm.okActions(okActions);
                    metricAlarm.alarmActions(alarmActions);
                    metricAlarm.insufficientDataActions(insufficientDataActions);
                    metricAlarm.dimensions(dimensions);
                    break;
                }
            }
        }
        return metricAlarm.build();
    }

    private static final MetricAlarmUnmarshaller INSTANCE = new MetricAlarmUnmarshaller();

    public static MetricAlarmUnmarshaller getInstance() {
        return INSTANCE;
    }
}
