/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * PutDashboardResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutDashboardResponseUnmarshaller implements Unmarshaller<PutDashboardResponse, StaxUnmarshallerContext> {

    public PutDashboardResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        PutDashboardResponse.Builder putDashboardResponse = PutDashboardResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<DashboardValidationMessage> dashboardValidationMessages = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                putDashboardResponse.dashboardValidationMessages(dashboardValidationMessages);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DashboardValidationMessages", targetDepth)) {
                    dashboardValidationMessages = new ArrayList<DashboardValidationMessage>();
                    continue;
                }

                if (context.testExpression("DashboardValidationMessages/member", targetDepth)) {
                    dashboardValidationMessages.add(DashboardValidationMessageUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    putDashboardResponse.dashboardValidationMessages(dashboardValidationMessages);
                    break;
                }
            }
        }
        return putDashboardResponse.build();
    }

    private static final PutDashboardResponseUnmarshaller INSTANCE = new PutDashboardResponseUnmarshaller();

    public static PutDashboardResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
