/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.DashboardEntry;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.transform.DashboardEntryUnmarshaller;

public class ListDashboardsResponseUnmarshaller
implements Unmarshaller<ListDashboardsResponse, StaxUnmarshallerContext> {
    private static final ListDashboardsResponseUnmarshaller INSTANCE = new ListDashboardsResponseUnmarshaller();

    public ListDashboardsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListDashboardsResponse.Builder listDashboardsResponse;
        block6: {
            listDashboardsResponse = ListDashboardsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            ArrayList<DashboardEntry> dashboardEntries = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listDashboardsResponse.dashboardEntries(dashboardEntries);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DashboardEntries", targetDepth)) {
                        dashboardEntries = new ArrayList<DashboardEntry>();
                        continue;
                    }
                    if (context.testExpression("DashboardEntries/member", targetDepth)) {
                        dashboardEntries.add(DashboardEntryUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("NextToken", targetDepth)) continue;
                    listDashboardsResponse.nextToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listDashboardsResponse.dashboardEntries(dashboardEntries);
        }
        return (ListDashboardsResponse)((Object)listDashboardsResponse.build());
    }

    public static ListDashboardsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

