/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListMetricsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<ListMetricsRequest.Builder, ListMetricsRequest> {
    private final String namespace;

    private final String metricName;

    private final List<DimensionFilter> dimensions;

    private final String nextToken;

    private ListMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The namespace to filter against.
     * </p>
     * 
     * @return The namespace to filter against.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the metric to filter against.
     * </p>
     * 
     * @return The name of the metric to filter against.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The dimensions to filter against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dimensions to filter against.
     */
    public List<DimensionFilter> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListMetricsRequest").add("Namespace", namespace()).add("MetricName", metricName())
                .add("Dimensions", dimensions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.of(clazz.cast(namespace()));
        case "MetricName":
            return Optional.of(clazz.cast(metricName()));
        case "Dimensions":
            return Optional.of(clazz.cast(dimensions()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, ListMetricsRequest> {
        /**
         * <p>
         * The namespace to filter against.
         * </p>
         * 
         * @param namespace
         *        The namespace to filter against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the metric to filter against.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to filter against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The dimensions to filter against.
         * </p>
         * 
         * @param dimensions
         *        The dimensions to filter against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<DimensionFilter> dimensions);

        /**
         * <p>
         * The dimensions to filter against.
         * </p>
         * 
         * @param dimensions
         *        The dimensions to filter against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionFilter... dimensions);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String namespace;

        private String metricName;

        private List<DimensionFilter> dimensions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsRequest model) {
            namespace(model.namespace);
            metricName(model.metricName);
            dimensions(model.dimensions);
            nextToken(model.nextToken);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<DimensionFilter.Builder> getDimensions() {
            return dimensions != null ? dimensions.stream().map(DimensionFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<DimensionFilter> dimensions) {
            this.dimensions = DimensionFiltersCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionFilter... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<DimensionFilter.BuilderImpl> dimensions) {
            this.dimensions = DimensionFiltersCopier.copyFromBuilder(dimensions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListMetricsRequest build() {
            return new ListMetricsRequest(this);
        }
    }
}
