/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListMetricsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListMetricsRequestMarshaller implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {

    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {

        if (listMetricsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListMetricsRequest> request = new DefaultRequest<ListMetricsRequest>(listMetricsRequest, "CloudWatchClient");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (listMetricsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(listMetricsRequest.namespace()));
        }

        if (listMetricsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(listMetricsRequest.metricName()));
        }

        java.util.List<DimensionFilter> dimensionsList = listMetricsRequest.dimensions();

        if (dimensionsList != null) {
            if (!dimensionsList.isEmpty()) {
                int dimensionsListIndex = 1;

                for (DimensionFilter dimensionsListValue : dimensionsList) {

                    if (dimensionsListValue.name() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                                StringUtils.fromString(dimensionsListValue.name()));
                    }

                    if (dimensionsListValue.value() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                                StringUtils.fromString(dimensionsListValue.value()));
                    }
                    dimensionsListIndex++;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }

        if (listMetricsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listMetricsRequest.nextToken()));
        }

        return request;
    }

}
