/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutMetricAlarmRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutMetricAlarmRequestMarshaller implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {

    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {

        if (putMetricAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutMetricAlarmRequest> request = new DefaultRequest<PutMetricAlarmRequest>(putMetricAlarmRequest,
                "CloudWatchClient");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putMetricAlarmRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(putMetricAlarmRequest.alarmName()));
        }

        if (putMetricAlarmRequest.alarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString(putMetricAlarmRequest.alarmDescription()));
        }

        if (putMetricAlarmRequest.actionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean(putMetricAlarmRequest.actionsEnabled()));
        }

        java.util.List<String> oKActionsList = putMetricAlarmRequest.okActions();

        if (oKActionsList != null) {
            if (!oKActionsList.isEmpty()) {
                int oKActionsListIndex = 1;

                for (String oKActionsListValue : oKActionsList) {
                    if (oKActionsListValue != null) {
                        request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString(oKActionsListValue));
                    }
                    oKActionsListIndex++;
                }
            } else {
                request.addParameter("OKActions", "");
            }
        }

        java.util.List<String> alarmActionsList = putMetricAlarmRequest.alarmActions();

        if (alarmActionsList != null) {
            if (!alarmActionsList.isEmpty()) {
                int alarmActionsListIndex = 1;

                for (String alarmActionsListValue : alarmActionsList) {
                    if (alarmActionsListValue != null) {
                        request.addParameter("AlarmActions.member." + alarmActionsListIndex,
                                StringUtils.fromString(alarmActionsListValue));
                    }
                    alarmActionsListIndex++;
                }
            } else {
                request.addParameter("AlarmActions", "");
            }
        }

        java.util.List<String> insufficientDataActionsList = putMetricAlarmRequest.insufficientDataActions();

        if (insufficientDataActionsList != null) {
            if (!insufficientDataActionsList.isEmpty()) {
                int insufficientDataActionsListIndex = 1;

                for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                    if (insufficientDataActionsListValue != null) {
                        request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex,
                                StringUtils.fromString(insufficientDataActionsListValue));
                    }
                    insufficientDataActionsListIndex++;
                }
            } else {
                request.addParameter("InsufficientDataActions", "");
            }
        }

        if (putMetricAlarmRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(putMetricAlarmRequest.metricName()));
        }

        if (putMetricAlarmRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricAlarmRequest.namespace()));
        }

        if (putMetricAlarmRequest.statisticString() != null) {
            request.addParameter("Statistic", StringUtils.fromString(putMetricAlarmRequest.statisticString()));
        }

        if (putMetricAlarmRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString(putMetricAlarmRequest.extendedStatistic()));
        }

        java.util.List<Dimension> dimensionsList = putMetricAlarmRequest.dimensions();

        if (dimensionsList != null) {
            if (!dimensionsList.isEmpty()) {
                int dimensionsListIndex = 1;

                for (Dimension dimensionsListValue : dimensionsList) {

                    if (dimensionsListValue.name() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                                StringUtils.fromString(dimensionsListValue.name()));
                    }

                    if (dimensionsListValue.value() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                                StringUtils.fromString(dimensionsListValue.value()));
                    }
                    dimensionsListIndex++;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }

        if (putMetricAlarmRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger(putMetricAlarmRequest.period()));
        }

        if (putMetricAlarmRequest.unitString() != null) {
            request.addParameter("Unit", StringUtils.fromString(putMetricAlarmRequest.unitString()));
        }

        if (putMetricAlarmRequest.evaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringUtils.fromInteger(putMetricAlarmRequest.evaluationPeriods()));
        }

        if (putMetricAlarmRequest.threshold() != null) {
            request.addParameter("Threshold", StringUtils.fromDouble(putMetricAlarmRequest.threshold()));
        }

        if (putMetricAlarmRequest.comparisonOperatorString() != null) {
            request.addParameter("ComparisonOperator", StringUtils.fromString(putMetricAlarmRequest.comparisonOperatorString()));
        }

        if (putMetricAlarmRequest.treatMissingData() != null) {
            request.addParameter("TreatMissingData", StringUtils.fromString(putMetricAlarmRequest.treatMissingData()));
        }

        if (putMetricAlarmRequest.evaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile",
                    StringUtils.fromString(putMetricAlarmRequest.evaluateLowSampleCountPercentile()));
        }

        return request;
    }

}
