/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmsResponse> {
    private final List<MetricAlarm> metricAlarms;
    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    public List<MetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAlarms());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse)((Object)obj);
        return Objects.equals(this.metricAlarms(), other.metricAlarms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmsResponse").add("MetricAlarms", this.metricAlarms()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricAlarms": {
                return Optional.of(clazz.cast(this.metricAlarms()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<MetricAlarm> metricAlarms;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            this.metricAlarms(model.metricAlarms);
            this.nextToken(model.nextToken);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            return this.metricAlarms != null ? (Collection)this.metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, DescribeAlarmsResponse> {
        public Builder metricAlarms(Collection<MetricAlarm> var1);

        public Builder metricAlarms(MetricAlarm ... var1);

        public Builder nextToken(String var1);
    }
}

