/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;

public class ListMetricsIterable
implements SdkIterable<ListMetricsResponse> {
    private final CloudWatchClient client;
    private final ListMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricsIterable(CloudWatchClient client, ListMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMetricsResponseFetcher();
    }

    public Iterator<ListMetricsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Metric> metrics() {
        Function<ListMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListMetricsIterable resume(ListMetricsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMetricsIterable(this.client, (ListMetricsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListMetricsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMetricsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMetricsResponseFetcher
    implements SyncPageFetcher<ListMetricsResponse> {
        private ListMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListMetricsResponse nextPage(ListMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricsIterable.this.client.listMetrics(ListMetricsIterable.this.firstRequest);
            }
            return ListMetricsIterable.this.client.listMetrics((ListMetricsRequest)((Object)ListMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

