/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Some part of the dashboard data is invalid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardInvalidInputErrorException extends CloudWatchException implements
        ToCopyableBuilder<DashboardInvalidInputErrorException.Builder, DashboardInvalidInputErrorException> {
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private DashboardInvalidInputErrorException(BuilderImpl builder) {
        super(builder);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the DashboardValidationMessages property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the DashboardValidationMessages property for this object.
     */
    public List<DashboardValidationMessage> dashboardValidationMessages() {
        return dashboardValidationMessages;
    }

    public interface Builder extends CopyableBuilder<Builder, DashboardInvalidInputErrorException>, CloudWatchException.Builder {
        /**
         * Sets the value of the DashboardValidationMessages property for this object.
         *
         * @param dashboardValidationMessages
         *        The new value for the DashboardValidationMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages);

        /**
         * Sets the value of the DashboardValidationMessages property for this object.
         *
         * @param dashboardValidationMessages
         *        The new value for the DashboardValidationMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages);

        /**
         * Sets the value of the DashboardValidationMessages property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<DashboardValidationMessage>.Builder}
         * avoiding the need to create one manually via {@link List<DashboardValidationMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardValidationMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dashboardValidationMessages(List<DashboardValidationMessage>)}.
         * 
         * @param dashboardValidationMessages
         *        a consumer that will call methods on {@link List<DashboardValidationMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardValidationMessages(List<DashboardValidationMessage>)
         */
        Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends CloudWatchException.BuilderImpl implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardInvalidInputErrorException model) {
            super(model);
            dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final Collection<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            return dashboardValidationMessages != null ? dashboardValidationMessages.stream()
                    .map(DashboardValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages) {
            dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(
                Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages) {
            dashboardValidationMessages(Stream.of(dashboardValidationMessages)
                    .map(c -> DashboardValidationMessage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardValidationMessages(
                Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DashboardInvalidInputErrorException build() {
            return new DashboardInvalidInputErrorException(this);
        }
    }
}
