/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDashboardsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DeleteDashboardsRequest.Builder, DeleteDashboardsRequest> {
    private final List<String> dashboardNames;

    private DeleteDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNames = builder.dashboardNames;
    }

    /**
     * <p>
     * The dashboards to be deleted. This parameter is required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The dashboards to be deleted. This parameter is required.
     */
    public List<String> dashboardNames() {
        return dashboardNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDashboardsRequest)) {
            return false;
        }
        DeleteDashboardsRequest other = (DeleteDashboardsRequest) obj;
        return Objects.equals(dashboardNames(), other.dashboardNames());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteDashboardsRequest").add("DashboardNames", dashboardNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardNames":
            return Optional.ofNullable(clazz.cast(dashboardNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, DeleteDashboardsRequest> {
        /**
         * <p>
         * The dashboards to be deleted. This parameter is required.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(Collection<String> dashboardNames);

        /**
         * <p>
         * The dashboards to be deleted. This parameter is required.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(String... dashboardNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> dashboardNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDashboardsRequest model) {
            super(model);
            dashboardNames(model.dashboardNames);
        }

        public final Collection<String> getDashboardNames() {
            return dashboardNames;
        }

        @Override
        public final Builder dashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardNames(String... dashboardNames) {
            dashboardNames(Arrays.asList(dashboardNames));
            return this;
        }

        public final void setDashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDashboardsRequest build() {
            return new DeleteDashboardsRequest(this);
        }
    }
}
