/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAlarmsRequest.Builder, DescribeAlarmsRequest> {
    private final List<String> alarmNames;

    private final String alarmNamePrefix;

    private final String stateValue;

    private final String actionPrefix;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the alarms.
     */
    public List<String> alarmNames() {
        return alarmNames;
    }

    /**
     * <p>
     * The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     * </p>
     * 
     * @return The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     */
    public String alarmNamePrefix() {
        return alarmNamePrefix;
    }

    /**
     * <p>
     * The state value to be used in matching alarms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value to be used in matching alarms.
     * @see StateValue
     */
    public StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The state value to be used in matching alarms.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value to be used in matching alarms.
     * @see StateValue
     */
    public String stateValueAsString() {
        return stateValue;
    }

    /**
     * <p>
     * The action name prefix.
     * </p>
     * 
     * @return The action name prefix.
     */
    public String actionPrefix() {
        return actionPrefix;
    }

    /**
     * <p>
     * The maximum number of alarm descriptions to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm descriptions to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmNames());
        hashCode = 31 * hashCode + Objects.hashCode(alarmNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest) obj;
        return Objects.equals(alarmNames(), other.alarmNames()) && Objects.equals(alarmNamePrefix(), other.alarmNamePrefix())
                && Objects.equals(stateValueAsString(), other.stateValueAsString())
                && Objects.equals(actionPrefix(), other.actionPrefix()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmsRequest").add("AlarmNames", alarmNames())
                .add("AlarmNamePrefix", alarmNamePrefix()).add("StateValue", stateValueAsString())
                .add("ActionPrefix", actionPrefix()).add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmNames":
            return Optional.ofNullable(clazz.cast(alarmNames()));
        case "AlarmNamePrefix":
            return Optional.ofNullable(clazz.cast(alarmNamePrefix()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        case "ActionPrefix":
            return Optional.ofNullable(clazz.cast(actionPrefix()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchRequest.Builder, CopyableBuilder<Builder, DescribeAlarmsRequest> {
        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);

        /**
         * <p>
         * The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * </p>
         * 
         * @param alarmNamePrefix
         *        The alarm name prefix. If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNamePrefix(String alarmNamePrefix);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The state value to be used in matching alarms.
         * </p>
         * 
         * @param stateValue
         *        The state value to be used in matching alarms.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The action name prefix.
         * </p>
         * 
         * @param actionPrefix
         *        The action name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPrefix(String actionPrefix);

        /**
         * <p>
         * The maximum number of alarm descriptions to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm descriptions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();

        private String alarmNamePrefix;

        private String stateValue;

        private String actionPrefix;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            super(model);
            alarmNames(model.alarmNames);
            alarmNamePrefix(model.alarmNamePrefix);
            stateValue(model.stateValue);
            actionPrefix(model.actionPrefix);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            return alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        public final String getAlarmNamePrefix() {
            return alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getActionPrefix() {
            return actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }
    }
}
