/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetMetricStatisticsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMetricStatisticsRequestMarshaller implements
        Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {

    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {

        if (getMetricStatisticsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetMetricStatisticsRequest> request = new DefaultRequest<GetMetricStatisticsRequest>(getMetricStatisticsRequest,
                "CloudWatchClient");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (getMetricStatisticsRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString(getMetricStatisticsRequest.namespace()));
        }

        if (getMetricStatisticsRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString(getMetricStatisticsRequest.metricName()));
        }

        if (getMetricStatisticsRequest.dimensions().isEmpty()
                && !(getMetricStatisticsRequest.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!getMetricStatisticsRequest.dimensions().isEmpty()
                && !(getMetricStatisticsRequest.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Dimension> dimensionsList = getMetricStatisticsRequest.dimensions();
            int dimensionsListIndex = 1;

            for (Dimension dimensionsListValue : dimensionsList) {

                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                            StringConversion.fromString(dimensionsListValue.name()));
                }

                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                            StringConversion.fromString(dimensionsListValue.value()));
                }
                dimensionsListIndex++;
            }
        }

        if (getMetricStatisticsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant(getMetricStatisticsRequest.startTime()));
        }

        if (getMetricStatisticsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant(getMetricStatisticsRequest.endTime()));
        }

        if (getMetricStatisticsRequest.period() != null) {
            request.addParameter("Period", StringConversion.fromInteger(getMetricStatisticsRequest.period()));
        }

        if (getMetricStatisticsRequest.statisticsAsStrings().isEmpty()
                && !(getMetricStatisticsRequest.statisticsAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Statistics", "");
        } else if (!getMetricStatisticsRequest.statisticsAsStrings().isEmpty()
                && !(getMetricStatisticsRequest.statisticsAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> statisticsList = getMetricStatisticsRequest.statisticsAsStrings();
            int statisticsListIndex = 1;

            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex,
                            StringConversion.fromString(statisticsListValue));
                }
                statisticsListIndex++;
            }
        }

        if (getMetricStatisticsRequest.extendedStatistics().isEmpty()
                && !(getMetricStatisticsRequest.extendedStatistics() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ExtendedStatistics", "");
        } else if (!getMetricStatisticsRequest.extendedStatistics().isEmpty()
                && !(getMetricStatisticsRequest.extendedStatistics() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> extendedStatisticsList = getMetricStatisticsRequest.extendedStatistics();
            int extendedStatisticsListIndex = 1;

            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex,
                            StringConversion.fromString(extendedStatisticsListValue));
                }
                extendedStatisticsListIndex++;
            }
        }

        if (getMetricStatisticsRequest.unitAsString() != null) {
            request.addParameter("Unit", StringConversion.fromString(getMetricStatisticsRequest.unitAsString()));
        }

        return request;
    }

}
