/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * MetricDataResult StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MetricDataResultUnmarshaller implements Unmarshaller<MetricDataResult, StaxUnmarshallerContext> {

    public MetricDataResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricDataResult.Builder metricDataResult = MetricDataResult.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<java.time.Instant> timestamps = null;
        java.util.List<Double> values = null;
        java.util.List<MessageData> messages = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                metricDataResult.timestamps(timestamps);
                metricDataResult.values(values);
                metricDataResult.messages(messages);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    metricDataResult.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Label", targetDepth)) {
                    metricDataResult.label(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Timestamps", targetDepth)) {
                    timestamps = new ArrayList<java.time.Instant>();
                    continue;
                }

                if (context.testExpression("Timestamps/member", targetDepth)) {
                    timestamps.add(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Values", targetDepth)) {
                    values = new ArrayList<Double>();
                    continue;
                }

                if (context.testExpression("Values/member", targetDepth)) {
                    values.add(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StatusCode", targetDepth)) {
                    metricDataResult.statusCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Messages", targetDepth)) {
                    messages = new ArrayList<MessageData>();
                    continue;
                }

                if (context.testExpression("Messages/member", targetDepth)) {
                    messages.add(MessageDataUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    metricDataResult.timestamps(timestamps);
                    metricDataResult.values(values);
                    metricDataResult.messages(messages);
                    break;
                }
            }
        }
        return metricDataResult.build();
    }

    private static final MetricDataResultUnmarshaller INSTANCE = new MetricDataResultUnmarshaller();

    public static MetricDataResultUnmarshaller getInstance() {
        return INSTANCE;
    }
}
