/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.awscore.protocol.xml.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmHistoryPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListMetricsPublisher;
import software.amazon.awssdk.services.cloudwatch.transform.DashboardInvalidInputErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DashboardNotFoundErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteDashboardsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetDashboardResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InternalServiceExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidFormatExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidNextTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidParameterCombinationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.InvalidParameterValueExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.LimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListDashboardsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.MissingRequiredParameterExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutDashboardResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ResourceNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudWatchAsyncClient
implements CloudWatchAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudWatchAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;

    protected DefaultCloudWatchAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.exceptionUnmarshallers = this.init();
    }

    public final String serviceName() {
        return "monitoring";
    }

    @Override
    public CompletableFuture<DeleteAlarmsResponse> deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteAlarmsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteAlarmsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteAlarmsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDashboardsResponse> deleteDashboards(DeleteDashboardsRequest deleteDashboardsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteDashboardsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDashboardsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteDashboardsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmHistoryResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAlarmHistoryRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeAlarmHistoryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAlarmHistoryPublisher describeAlarmHistoryPaginator(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        return new DescribeAlarmHistoryPublisher(this, this.applyPaginatorUserAgent(describeAlarmHistoryRequest));
    }

    @Override
    public CompletableFuture<DescribeAlarmsResponse> describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAlarmsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeAlarmsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAlarmsForMetricResponse> describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmsForMetricResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAlarmsForMetricRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeAlarmsForMetricRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAlarmsPublisher describeAlarmsPaginator(DescribeAlarmsRequest describeAlarmsRequest) {
        return new DescribeAlarmsPublisher(this, this.applyPaginatorUserAgent(describeAlarmsRequest));
    }

    @Override
    public CompletableFuture<DisableAlarmActionsResponse> disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DisableAlarmActionsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisableAlarmActionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)disableAlarmActionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAlarmActionsResponse> enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new EnableAlarmActionsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new EnableAlarmActionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)enableAlarmActionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest getDashboardRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetDashboardResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDashboardRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getDashboardRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMetricDataResponse> getMetricData(GetMetricDataRequest getMetricDataRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetMetricDataResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetMetricDataRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getMetricDataRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMetricStatisticsResponse> getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetMetricStatisticsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetMetricStatisticsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getMetricStatisticsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDashboardsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDashboardsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listDashboardsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMetricsResponse> listMetrics(ListMetricsRequest listMetricsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListMetricsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListMetricsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listMetricsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMetricsPublisher listMetricsPaginator(ListMetricsRequest listMetricsRequest) {
        return new ListMetricsPublisher(this, this.applyPaginatorUserAgent(listMetricsRequest));
    }

    @Override
    public CompletableFuture<PutDashboardResponse> putDashboard(PutDashboardRequest putDashboardRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PutDashboardResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutDashboardRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)putDashboardRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricAlarmResponse> putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PutMetricAlarmResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutMetricAlarmRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)putMetricAlarmRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricDataResponse> putMetricData(PutMetricDataRequest putMetricDataRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PutMetricDataResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutMetricDataRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)putMetricDataRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetAlarmStateResponse> setAlarmState(SetAlarmStateRequest setAlarmStateRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetAlarmStateResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetAlarmStateRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setAlarmStateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        ArrayList<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AwsServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new ResourceNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidParameterCombinationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidFormatExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new MissingRequiredParameterExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DashboardNotFoundErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DashboardInvalidInputErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InternalServiceExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StandardErrorUnmarshaller(CloudWatchException.class));
        return unmarshallers;
    }

    private <T extends CloudWatchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.1").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

