/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetMetricDataResponse> {
    private final List<MetricDataResult> metricDataResults;
    private final String nextToken;

    private GetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricDataResults = builder.metricDataResults;
        this.nextToken = builder.nextToken;
    }

    public List<MetricDataResult> metricDataResults() {
        return this.metricDataResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDataResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataResponse)) {
            return false;
        }
        GetMetricDataResponse other = (GetMetricDataResponse)((Object)obj);
        return Objects.equals(this.metricDataResults(), other.metricDataResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetMetricDataResponse").add("MetricDataResults", this.metricDataResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDataResults": {
                return Optional.ofNullable(clazz.cast(this.metricDataResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<MetricDataResult> metricDataResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataResponse model) {
            super(model);
            this.metricDataResults(model.metricDataResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<MetricDataResult.Builder> getMetricDataResults() {
            return this.metricDataResults != null ? (Collection)this.metricDataResults.stream().map(MetricDataResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDataResults(Collection<MetricDataResult> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copy(metricDataResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(MetricDataResult ... metricDataResults) {
            this.metricDataResults(Arrays.asList(metricDataResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(Consumer<MetricDataResult.Builder> ... metricDataResults) {
            this.metricDataResults(Stream.of(metricDataResults).map(c -> (MetricDataResult)((MetricDataResult.Builder)MetricDataResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDataResults(Collection<MetricDataResult.BuilderImpl> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copyFromBuilder(metricDataResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMetricDataResponse build() {
            return new GetMetricDataResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, GetMetricDataResponse> {
        public Builder metricDataResults(Collection<MetricDataResult> var1);

        public Builder metricDataResults(MetricDataResult ... var1);

        public Builder metricDataResults(Consumer<MetricDataResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

