/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;
import software.amazon.awssdk.services.cloudwatch.transform.MetricUnmarshaller;

public class MetricStatUnmarshaller
implements Unmarshaller<MetricStat, StaxUnmarshallerContext> {
    private static final MetricStatUnmarshaller INSTANCE = new MetricStatUnmarshaller();

    public MetricStat unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MetricStat.Builder metricStat = MetricStat.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Metric", targetDepth)) {
                    metricStat.metric(MetricUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Period", targetDepth)) {
                    metricStat.period(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stat", targetDepth)) {
                    metricStat.stat(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Unit", targetDepth)) continue;
                metricStat.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MetricStat)metricStat.build();
    }

    public static MetricStatUnmarshaller getInstance() {
        return INSTANCE;
    }
}

