/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * PutMetricDataRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutMetricDataRequestMarshaller implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {

    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {

        if (putMetricDataRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putMetricDataRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString(putMetricDataRequest.namespace()));
        }

        if (putMetricDataRequest.metricData().isEmpty()
                && !(putMetricDataRequest.metricData() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("MetricData", "");
        } else if (!putMetricDataRequest.metricData().isEmpty()
                && !(putMetricDataRequest.metricData() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MetricDatum> metricDataList = putMetricDataRequest.metricData();
            int metricDataListIndex = 1;

            for (MetricDatum metricDataListValue : metricDataList) {

                if (metricDataListValue.metricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName",
                            StringConversion.fromString(metricDataListValue.metricName()));
                }

                if (metricDataListValue.dimensions().isEmpty()
                        && !(metricDataListValue.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions", "");
                } else if (!metricDataListValue.dimensions().isEmpty()
                        && !(metricDataListValue.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    java.util.List<Dimension> dimensionsList = metricDataListValue.dimensions();
                    int dimensionsListIndex = 1;

                    for (Dimension dimensionsListValue : dimensionsList) {

                        if (dimensionsListValue.name() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member."
                                    + dimensionsListIndex + ".Name", StringConversion.fromString(dimensionsListValue.name()));
                        }

                        if (dimensionsListValue.value() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member."
                                    + dimensionsListIndex + ".Value", StringConversion.fromString(dimensionsListValue.value()));
                        }
                        dimensionsListIndex++;
                    }
                }

                if (metricDataListValue.timestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp",
                            StringConversion.fromInstant(metricDataListValue.timestamp()));
                }

                if (metricDataListValue.value() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value",
                            StringConversion.fromDouble(metricDataListValue.value()));
                }

                StatisticSet statisticValues = metricDataListValue.statisticValues();
                if (statisticValues != null) {

                    if (statisticValues.sampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount",
                                StringConversion.fromDouble(statisticValues.sampleCount()));
                    }

                    if (statisticValues.sum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum",
                                StringConversion.fromDouble(statisticValues.sum()));
                    }

                    if (statisticValues.minimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum",
                                StringConversion.fromDouble(statisticValues.minimum()));
                    }

                    if (statisticValues.maximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum",
                                StringConversion.fromDouble(statisticValues.maximum()));
                    }
                }

                if (metricDataListValue.unitAsString() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit",
                            StringConversion.fromString(metricDataListValue.unitAsString()));
                }

                if (metricDataListValue.storageResolution() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".StorageResolution",
                            StringConversion.fromInteger(metricDataListValue.storageResolution()));
                }
                metricDataListIndex++;
            }
        }

        return request;
    }

}
