/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DimensionFilter;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;

public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        if (listMetricsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listMetricsRequest, "CloudWatchClient");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMetricsRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString((String)listMetricsRequest.namespace()));
        }
        if (listMetricsRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString((String)listMetricsRequest.metricName()));
        }
        if (listMetricsRequest.dimensions().isEmpty() && !(listMetricsRequest.dimensions() instanceof SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!listMetricsRequest.dimensions().isEmpty() && !(listMetricsRequest.dimensions() instanceof SdkAutoConstructList)) {
            List<DimensionFilter> dimensionsList = listMetricsRequest.dimensions();
            int dimensionsListIndex = 1;
            for (DimensionFilter dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (listMetricsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listMetricsRequest.nextToken()));
        }
        return request;
    }
}

