/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error or warning for the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardValidationMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardValidationMessage.Builder, DashboardValidationMessage> {
    private static final SdkField<String> DATA_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardValidationMessage::dataPath)).setter(setter(Builder::dataPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPath").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardValidationMessage::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_PATH_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataPath;

    private final String message;

    private DashboardValidationMessage(BuilderImpl builder) {
        this.dataPath = builder.dataPath;
        this.message = builder.message;
    }

    /**
     * <p>
     * The data path related to the message.
     * </p>
     * 
     * @return The data path related to the message.
     */
    public String dataPath() {
        return dataPath;
    }

    /**
     * <p>
     * A message describing the error or warning.
     * </p>
     * 
     * @return A message describing the error or warning.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataPath());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardValidationMessage)) {
            return false;
        }
        DashboardValidationMessage other = (DashboardValidationMessage) obj;
        return Objects.equals(dataPath(), other.dataPath()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("DashboardValidationMessage").add("DataPath", dataPath()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataPath":
            return Optional.ofNullable(clazz.cast(dataPath()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardValidationMessage, T> g) {
        return obj -> g.apply((DashboardValidationMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardValidationMessage> {
        /**
         * <p>
         * The data path related to the message.
         * </p>
         * 
         * @param dataPath
         *        The data path related to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPath(String dataPath);

        /**
         * <p>
         * A message describing the error or warning.
         * </p>
         * 
         * @param message
         *        A message describing the error or warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String dataPath;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardValidationMessage model) {
            dataPath(model.dataPath);
            message(model.message);
        }

        public final String getDataPath() {
            return dataPath;
        }

        @Override
        public final Builder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public final void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public DashboardValidationMessage build() {
            return new DashboardValidationMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
