/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightRuleReportResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetInsightRuleReportResponse.Builder, GetInsightRuleReportResponse> {
    private static final SdkField<List<String>> KEY_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetInsightRuleReportResponse::keyLabels))
            .setter(setter(Builder::keyLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGGREGATION_STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInsightRuleReportResponse::aggregationStatistic)).setter(setter(Builder::aggregationStatistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationStatistic").build())
            .build();

    private static final SdkField<Double> AGGREGATE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(GetInsightRuleReportResponse::aggregateValue)).setter(setter(Builder::aggregateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateValue").build()).build();

    private static final SdkField<Long> APPROXIMATE_UNIQUE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetInsightRuleReportResponse::approximateUniqueCount)).setter(setter(Builder::approximateUniqueCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateUniqueCount").build())
            .build();

    private static final SdkField<List<InsightRuleContributor>> CONTRIBUTORS_FIELD = SdkField
            .<List<InsightRuleContributor>> builder(MarshallingType.LIST)
            .getter(getter(GetInsightRuleReportResponse::contributors))
            .setter(setter(Builder::contributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightRuleContributor> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightRuleContributor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InsightRuleMetricDatapoint>> METRIC_DATAPOINTS_FIELD = SdkField
            .<List<InsightRuleMetricDatapoint>> builder(MarshallingType.LIST)
            .getter(getter(GetInsightRuleReportResponse::metricDatapoints))
            .setter(setter(Builder::metricDatapoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDatapoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightRuleMetricDatapoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightRuleMetricDatapoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_LABELS_FIELD,
            AGGREGATION_STATISTIC_FIELD, AGGREGATE_VALUE_FIELD, APPROXIMATE_UNIQUE_COUNT_FIELD, CONTRIBUTORS_FIELD,
            METRIC_DATAPOINTS_FIELD));

    private final List<String> keyLabels;

    private final String aggregationStatistic;

    private final Double aggregateValue;

    private final Long approximateUniqueCount;

    private final List<InsightRuleContributor> contributors;

    private final List<InsightRuleMetricDatapoint> metricDatapoints;

    private GetInsightRuleReportResponse(BuilderImpl builder) {
        super(builder);
        this.keyLabels = builder.keyLabels;
        this.aggregationStatistic = builder.aggregationStatistic;
        this.aggregateValue = builder.aggregateValue;
        this.approximateUniqueCount = builder.approximateUniqueCount;
        this.contributors = builder.contributors;
        this.metricDatapoints = builder.metricDatapoints;
    }

    /**
     * <p>
     * An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
     * contributors. If the rule contains more than one key, then each unique combination of values for the keys is
     * counted as a unique contributor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
     *         contributors. If the rule contains more than one key, then each unique combination of values for the keys
     *         is counted as a unique contributor.
     */
    public List<String> keyLabels() {
        return keyLabels;
    }

    /**
     * <p>
     * Specifies whether this rule aggregates contributor data by COUNT or SUM.
     * </p>
     * 
     * @return Specifies whether this rule aggregates contributor data by COUNT or SUM.
     */
    public String aggregationStatistic() {
        return aggregationStatistic;
    }

    /**
     * <p>
     * The sum of the values from all individual contributors that match the rule.
     * </p>
     * 
     * @return The sum of the values from all individual contributors that match the rule.
     */
    public Double aggregateValue() {
        return aggregateValue;
    }

    /**
     * <p>
     * An approximate count of the unique contributors found by this rule in this time period.
     * </p>
     * 
     * @return An approximate count of the unique contributors found by this rule in this time period.
     */
    public Long approximateUniqueCount() {
        return approximateUniqueCount;
    }

    /**
     * <p>
     * An array of the unique contributors found by this rule in this time period. If the rule contains multiple keys,
     * each combination of values for the keys counts as a unique contributor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of the unique contributors found by this rule in this time period. If the rule contains multiple
     *         keys, each combination of values for the keys counts as a unique contributor.
     */
    public List<InsightRuleContributor> contributors() {
        return contributors;
    }

    /**
     * <p>
     * A time series of metric data points that matches the time period in the rule request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A time series of metric data points that matches the time period in the rule request.
     */
    public List<InsightRuleMetricDatapoint> metricDatapoints() {
        return metricDatapoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyLabels());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateValue());
        hashCode = 31 * hashCode + Objects.hashCode(approximateUniqueCount());
        hashCode = 31 * hashCode + Objects.hashCode(contributors());
        hashCode = 31 * hashCode + Objects.hashCode(metricDatapoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightRuleReportResponse)) {
            return false;
        }
        GetInsightRuleReportResponse other = (GetInsightRuleReportResponse) obj;
        return Objects.equals(keyLabels(), other.keyLabels())
                && Objects.equals(aggregationStatistic(), other.aggregationStatistic())
                && Objects.equals(aggregateValue(), other.aggregateValue())
                && Objects.equals(approximateUniqueCount(), other.approximateUniqueCount())
                && Objects.equals(contributors(), other.contributors())
                && Objects.equals(metricDatapoints(), other.metricDatapoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInsightRuleReportResponse").add("KeyLabels", keyLabels())
                .add("AggregationStatistic", aggregationStatistic()).add("AggregateValue", aggregateValue())
                .add("ApproximateUniqueCount", approximateUniqueCount()).add("Contributors", contributors())
                .add("MetricDatapoints", metricDatapoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyLabels":
            return Optional.ofNullable(clazz.cast(keyLabels()));
        case "AggregationStatistic":
            return Optional.ofNullable(clazz.cast(aggregationStatistic()));
        case "AggregateValue":
            return Optional.ofNullable(clazz.cast(aggregateValue()));
        case "ApproximateUniqueCount":
            return Optional.ofNullable(clazz.cast(approximateUniqueCount()));
        case "Contributors":
            return Optional.ofNullable(clazz.cast(contributors()));
        case "MetricDatapoints":
            return Optional.ofNullable(clazz.cast(metricDatapoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightRuleReportResponse, T> g) {
        return obj -> g.apply((GetInsightRuleReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightRuleReportResponse> {
        /**
         * <p>
         * An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
         * contributors. If the rule contains more than one key, then each unique combination of values for the keys is
         * counted as a unique contributor.
         * </p>
         * 
         * @param keyLabels
         *        An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
         *        contributors. If the rule contains more than one key, then each unique combination of values for the
         *        keys is counted as a unique contributor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyLabels(Collection<String> keyLabels);

        /**
         * <p>
         * An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
         * contributors. If the rule contains more than one key, then each unique combination of values for the keys is
         * counted as a unique contributor.
         * </p>
         * 
         * @param keyLabels
         *        An array of the strings used as the keys for this rule. The keys are the dimensions used to classify
         *        contributors. If the rule contains more than one key, then each unique combination of values for the
         *        keys is counted as a unique contributor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyLabels(String... keyLabels);

        /**
         * <p>
         * Specifies whether this rule aggregates contributor data by COUNT or SUM.
         * </p>
         * 
         * @param aggregationStatistic
         *        Specifies whether this rule aggregates contributor data by COUNT or SUM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationStatistic(String aggregationStatistic);

        /**
         * <p>
         * The sum of the values from all individual contributors that match the rule.
         * </p>
         * 
         * @param aggregateValue
         *        The sum of the values from all individual contributors that match the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateValue(Double aggregateValue);

        /**
         * <p>
         * An approximate count of the unique contributors found by this rule in this time period.
         * </p>
         * 
         * @param approximateUniqueCount
         *        An approximate count of the unique contributors found by this rule in this time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateUniqueCount(Long approximateUniqueCount);

        /**
         * <p>
         * An array of the unique contributors found by this rule in this time period. If the rule contains multiple
         * keys, each combination of values for the keys counts as a unique contributor.
         * </p>
         * 
         * @param contributors
         *        An array of the unique contributors found by this rule in this time period. If the rule contains
         *        multiple keys, each combination of values for the keys counts as a unique contributor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributors(Collection<InsightRuleContributor> contributors);

        /**
         * <p>
         * An array of the unique contributors found by this rule in this time period. If the rule contains multiple
         * keys, each combination of values for the keys counts as a unique contributor.
         * </p>
         * 
         * @param contributors
         *        An array of the unique contributors found by this rule in this time period. If the rule contains
         *        multiple keys, each combination of values for the keys counts as a unique contributor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributors(InsightRuleContributor... contributors);

        /**
         * <p>
         * An array of the unique contributors found by this rule in this time period. If the rule contains multiple
         * keys, each combination of values for the keys counts as a unique contributor.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InsightRuleContributor>.Builder} avoiding
         * the need to create one manually via {@link List<InsightRuleContributor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightRuleContributor>.Builder#build()} is called
         * immediately and its result is passed to {@link #contributors(List<InsightRuleContributor>)}.
         * 
         * @param contributors
         *        a consumer that will call methods on {@link List<InsightRuleContributor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributors(List<InsightRuleContributor>)
         */
        Builder contributors(Consumer<InsightRuleContributor.Builder>... contributors);

        /**
         * <p>
         * A time series of metric data points that matches the time period in the rule request.
         * </p>
         * 
         * @param metricDatapoints
         *        A time series of metric data points that matches the time period in the rule request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> metricDatapoints);

        /**
         * <p>
         * A time series of metric data points that matches the time period in the rule request.
         * </p>
         * 
         * @param metricDatapoints
         *        A time series of metric data points that matches the time period in the rule request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDatapoints(InsightRuleMetricDatapoint... metricDatapoints);

        /**
         * <p>
         * A time series of metric data points that matches the time period in the rule request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InsightRuleMetricDatapoint>.Builder}
         * avoiding the need to create one manually via {@link List<InsightRuleMetricDatapoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightRuleMetricDatapoint>.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDatapoints(List<InsightRuleMetricDatapoint>)}.
         * 
         * @param metricDatapoints
         *        a consumer that will call methods on {@link List<InsightRuleMetricDatapoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDatapoints(List<InsightRuleMetricDatapoint>)
         */
        Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder>... metricDatapoints);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<String> keyLabels = DefaultSdkAutoConstructList.getInstance();

        private String aggregationStatistic;

        private Double aggregateValue;

        private Long approximateUniqueCount;

        private List<InsightRuleContributor> contributors = DefaultSdkAutoConstructList.getInstance();

        private List<InsightRuleMetricDatapoint> metricDatapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightRuleReportResponse model) {
            super(model);
            keyLabels(model.keyLabels);
            aggregationStatistic(model.aggregationStatistic);
            aggregateValue(model.aggregateValue);
            approximateUniqueCount(model.approximateUniqueCount);
            contributors(model.contributors);
            metricDatapoints(model.metricDatapoints);
        }

        public final Collection<String> getKeyLabels() {
            return keyLabels;
        }

        @Override
        public final Builder keyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyLabels(String... keyLabels) {
            keyLabels(Arrays.asList(keyLabels));
            return this;
        }

        public final void setKeyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
        }

        public final String getAggregationStatistic() {
            return aggregationStatistic;
        }

        @Override
        public final Builder aggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
            return this;
        }

        public final void setAggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
        }

        public final Double getAggregateValue() {
            return aggregateValue;
        }

        @Override
        public final Builder aggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
            return this;
        }

        public final void setAggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public final Long getApproximateUniqueCount() {
            return approximateUniqueCount;
        }

        @Override
        public final Builder approximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
            return this;
        }

        public final void setApproximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
        }

        public final Collection<InsightRuleContributor.Builder> getContributors() {
            return contributors != null ? contributors.stream().map(InsightRuleContributor::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contributors(Collection<InsightRuleContributor> contributors) {
            this.contributors = InsightRuleContributorsCopier.copy(contributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(InsightRuleContributor... contributors) {
            contributors(Arrays.asList(contributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(Consumer<InsightRuleContributor.Builder>... contributors) {
            contributors(Stream.of(contributors).map(c -> InsightRuleContributor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContributors(Collection<InsightRuleContributor.BuilderImpl> contributors) {
            this.contributors = InsightRuleContributorsCopier.copyFromBuilder(contributors);
        }

        public final Collection<InsightRuleMetricDatapoint.Builder> getMetricDatapoints() {
            return metricDatapoints != null ? metricDatapoints.stream().map(InsightRuleMetricDatapoint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copy(metricDatapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(InsightRuleMetricDatapoint... metricDatapoints) {
            metricDatapoints(Arrays.asList(metricDatapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder>... metricDatapoints) {
            metricDatapoints(Stream.of(metricDatapoints).map(c -> InsightRuleMetricDatapoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDatapoints(Collection<InsightRuleMetricDatapoint.BuilderImpl> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copyFromBuilder(metricDatapoints);
        }

        @Override
        public GetInsightRuleReportResponse build() {
            return new GetInsightRuleReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
