/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightRuleReportRequest extends CloudWatchRequest implements
        ToCopyableBuilder<GetInsightRuleReportRequest.Builder, GetInsightRuleReportRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInsightRuleReportRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetInsightRuleReportRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetInsightRuleReportRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetInsightRuleReportRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<Integer> MAX_CONTRIBUTOR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetInsightRuleReportRequest::maxContributorCount)).setter(setter(Builder::maxContributorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContributorCount").build())
            .build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetInsightRuleReportRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInsightRuleReportRequest::orderBy)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, MAX_CONTRIBUTOR_COUNT_FIELD, METRICS_FIELD, ORDER_BY_FIELD));

    private final String ruleName;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer period;

    private final Integer maxContributorCount;

    private final List<String> metrics;

    private final String orderBy;

    private GetInsightRuleReportRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.maxContributorCount = builder.maxContributorCount;
        this.metrics = builder.metrics;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The name of the rule that you want to see data from.
     * </p>
     * 
     * @return The name of the rule that you want to see data from.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
     * <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
     * </p>
     * 
     * @return The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
     *         <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
     * <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
     * </p>
     * 
     * @return The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
     *         <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The period, in seconds, to use for the statistics in the <code>InsightRuleMetricDatapoint</code> results.
     * </p>
     * 
     * @return The period, in seconds, to use for the statistics in the <code>InsightRuleMetricDatapoint</code> results.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the default
     * of 10 is used.
     * </p>
     * 
     * @return The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the
     *         default of 10 is used.
     */
    public Integer maxContributorCount() {
        return maxContributorCount;
    }

    /**
     * <p>
     * Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or more
     * of the following metrics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UniqueContributors</code> -- the number of unique contributors for each data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of the
     * contributor may change for each data point in the graph.
     * </p>
     * <p>
     * If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most
     * occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the
     * highest sum in the log field specified by the rule's <code>Value</code>, during that period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> -- the number of data points matched by the rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> -- the sum of the values from all contributors during the time period represented by that data
     * point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Minimum</code> -- the minimum value from a single observation during the time period represented by that
     * data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> -- the maximum value from a single observation during the time period represented by that
     * data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> -- the average value from all contributors during the time period represented by that data
     * point.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies which metrics to use for aggregation of contributor values for the report. You can specify one
     *         or more of the following metrics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UniqueContributors</code> -- the number of unique contributors for each data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of
     *         the contributor may change for each data point in the graph.
     *         </p>
     *         <p>
     *         If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the
     *         most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor
     *         with the highest sum in the log field specified by the rule's <code>Value</code>, during that period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SampleCount</code> -- the number of data points matched by the rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Sum</code> -- the sum of the values from all contributors during the time period represented by
     *         that data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Minimum</code> -- the minimum value from a single observation during the time period represented by
     *         that data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Maximum</code> -- the maximum value from a single observation during the time period represented by
     *         that data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> -- the average value from all contributors during the time period represented by
     *         that data point.
     *         </p>
     *         </li>
     */
    public List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * Determines what statistic to use to rank the contributors. Valid values are SUM and MAXIMUM.
     * </p>
     * 
     * @return Determines what statistic to use to rank the contributors. Valid values are SUM and MAXIMUM.
     */
    public String orderBy() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(maxContributorCount());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightRuleReportRequest)) {
            return false;
        }
        GetInsightRuleReportRequest other = (GetInsightRuleReportRequest) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(period(), other.period())
                && Objects.equals(maxContributorCount(), other.maxContributorCount())
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(orderBy(), other.orderBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInsightRuleReportRequest").add("RuleName", ruleName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Period", period()).add("MaxContributorCount", maxContributorCount())
                .add("Metrics", metrics()).add("OrderBy", orderBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "MaxContributorCount":
            return Optional.ofNullable(clazz.cast(maxContributorCount()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "OrderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightRuleReportRequest, T> g) {
        return obj -> g.apply((GetInsightRuleReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightRuleReportRequest> {
        /**
         * <p>
         * The name of the rule that you want to see data from.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule that you want to see data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
         * <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
         * </p>
         * 
         * @param startTime
         *        The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
         *        <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
         * <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
         * </p>
         * 
         * @param endTime
         *        The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as
         *        <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The period, in seconds, to use for the statistics in the <code>InsightRuleMetricDatapoint</code> results.
         * </p>
         * 
         * @param period
         *        The period, in seconds, to use for the statistics in the <code>InsightRuleMetricDatapoint</code>
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the
         * default of 10 is used.
         * </p>
         * 
         * @param maxContributorCount
         *        The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this,
         *        the default of 10 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxContributorCount(Integer maxContributorCount);

        /**
         * <p>
         * Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or
         * more of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UniqueContributors</code> -- the number of unique contributors for each data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of the
         * contributor may change for each data point in the graph.
         * </p>
         * <p>
         * If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most
         * occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the
         * highest sum in the log field specified by the rule's <code>Value</code>, during that period.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> -- the number of data points matched by the rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> -- the sum of the values from all contributors during the time period represented by that
         * data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Minimum</code> -- the minimum value from a single observation during the time period represented by
         * that data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> -- the maximum value from a single observation during the time period represented by
         * that data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> -- the average value from all contributors during the time period represented by that
         * data point.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        Specifies which metrics to use for aggregation of contributor values for the report. You can specify
         *        one or more of the following metrics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UniqueContributors</code> -- the number of unique contributors for each data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity
         *        of the contributor may change for each data point in the graph.
         *        </p>
         *        <p>
         *        If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the
         *        most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor
         *        with the highest sum in the log field specified by the rule's <code>Value</code>, during that period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> -- the number of data points matched by the rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> -- the sum of the values from all contributors during the time period represented by
         *        that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Minimum</code> -- the minimum value from a single observation during the time period represented
         *        by that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> -- the maximum value from a single observation during the time period represented
         *        by that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> -- the average value from all contributors during the time period represented by
         *        that data point.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or
         * more of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UniqueContributors</code> -- the number of unique contributors for each data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of the
         * contributor may change for each data point in the graph.
         * </p>
         * <p>
         * If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most
         * occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the
         * highest sum in the log field specified by the rule's <code>Value</code>, during that period.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> -- the number of data points matched by the rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> -- the sum of the values from all contributors during the time period represented by that
         * data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Minimum</code> -- the minimum value from a single observation during the time period represented by
         * that data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> -- the maximum value from a single observation during the time period represented by
         * that data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> -- the average value from all contributors during the time period represented by that
         * data point.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        Specifies which metrics to use for aggregation of contributor values for the report. You can specify
         *        one or more of the following metrics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UniqueContributors</code> -- the number of unique contributors for each data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity
         *        of the contributor may change for each data point in the graph.
         *        </p>
         *        <p>
         *        If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the
         *        most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor
         *        with the highest sum in the log field specified by the rule's <code>Value</code>, during that period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> -- the number of data points matched by the rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> -- the sum of the values from all contributors during the time period represented by
         *        that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Minimum</code> -- the minimum value from a single observation during the time period represented
         *        by that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> -- the maximum value from a single observation during the time period represented
         *        by that data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> -- the average value from all contributors during the time period represented by
         *        that data point.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * Determines what statistic to use to rank the contributors. Valid values are SUM and MAXIMUM.
         * </p>
         * 
         * @param orderBy
         *        Determines what statistic to use to rank the contributors. Valid values are SUM and MAXIMUM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(String orderBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String ruleName;

        private Instant startTime;

        private Instant endTime;

        private Integer period;

        private Integer maxContributorCount;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightRuleReportRequest model) {
            super(model);
            ruleName(model.ruleName);
            startTime(model.startTime);
            endTime(model.endTime);
            period(model.period);
            maxContributorCount(model.maxContributorCount);
            metrics(model.metrics);
            orderBy(model.orderBy);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Integer getMaxContributorCount() {
            return maxContributorCount;
        }

        @Override
        public final Builder maxContributorCount(Integer maxContributorCount) {
            this.maxContributorCount = maxContributorCount;
            return this;
        }

        public final void setMaxContributorCount(Integer maxContributorCount) {
            this.maxContributorCount = maxContributorCount;
        }

        public final Collection<String> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = InsightRuleMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = InsightRuleMetricListCopier.copy(metrics);
        }

        public final String getOrderBy() {
            return orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInsightRuleReportRequest build() {
            return new GetInsightRuleReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
