/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAlarmActionsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<EnableAlarmActionsRequest.Builder, EnableAlarmActionsRequest> {
    private static final SdkField<List<String>> ALARM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableAlarmActionsRequest::alarmNames))
            .setter(setter(Builder::alarmNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAMES_FIELD));

    private final List<String> alarmNames;

    private EnableAlarmActionsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
    }

    /**
     * Returns true if the AlarmNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAlarmNames() {
        return alarmNames != null && !(alarmNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlarmNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the alarms.
     */
    public List<String> alarmNames() {
        return alarmNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAlarmActionsRequest)) {
            return false;
        }
        EnableAlarmActionsRequest other = (EnableAlarmActionsRequest) obj;
        return Objects.equals(alarmNames(), other.alarmNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableAlarmActionsRequest").add("AlarmNames", alarmNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmNames":
            return Optional.ofNullable(clazz.cast(alarmNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableAlarmActionsRequest, T> g) {
        return obj -> g.apply((EnableAlarmActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableAlarmActionsRequest> {
        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAlarmActionsRequest model) {
            super(model);
            alarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAlarmActionsRequest build() {
            return new EnableAlarmActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
