/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmHistoryRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAlarmHistoryRequest.Builder, DescribeAlarmHistoryRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAlarmHistoryRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> HISTORY_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAlarmHistoryRequest::historyItemTypeAsString)).setter(setter(Builder::historyItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryItemType").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAlarmHistoryRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAlarmHistoryRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeAlarmHistoryRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAlarmHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            HISTORY_ITEM_TYPE_FIELD, START_DATE_FIELD, END_DATE_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private final String alarmName;

    private final String historyItemType;

    private final Instant startDate;

    private final Instant endDate;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The type of alarm histories to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeAsString}.
     * </p>
     * 
     * @return The type of alarm histories to retrieve.
     * @see HistoryItemType
     */
    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(historyItemType);
    }

    /**
     * <p>
     * The type of alarm histories to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeAsString}.
     * </p>
     * 
     * @return The type of alarm histories to retrieve.
     * @see HistoryItemType
     */
    public String historyItemTypeAsString() {
        return historyItemType;
    }

    /**
     * <p>
     * The starting date to retrieve alarm history.
     * </p>
     * 
     * @return The starting date to retrieve alarm history.
     */
    public Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date to retrieve alarm history.
     * </p>
     * 
     * @return The ending date to retrieve alarm history.
     */
    public Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The maximum number of alarm history records to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm history records to retrieve.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(historyItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest) obj;
        return Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(historyItemTypeAsString(), other.historyItemTypeAsString())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmHistoryRequest").add("AlarmName", alarmName())
                .add("HistoryItemType", historyItemTypeAsString()).add("StartDate", startDate()).add("EndDate", endDate())
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "HistoryItemType":
            return Optional.ofNullable(clazz.cast(historyItemTypeAsString()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmHistoryRequest, T> g) {
        return obj -> g.apply((DescribeAlarmHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(String historyItemType);

        /**
         * <p>
         * The type of alarm histories to retrieve.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm histories to retrieve.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(HistoryItemType historyItemType);

        /**
         * <p>
         * The starting date to retrieve alarm history.
         * </p>
         * 
         * @param startDate
         *        The starting date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The ending date to retrieve alarm history.
         * </p>
         * 
         * @param endDate
         *        The ending date to retrieve alarm history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The maximum number of alarm history records to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm history records to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String historyItemType;

        private Instant startDate;

        private Instant endDate;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            super(model);
            alarmName(model.alarmName);
            historyItemType(model.historyItemType);
            startDate(model.startDate);
            endDate(model.endDate);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemTypeAsString() {
            return historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType == null ? null : historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
