/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the history of a specific alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmHistoryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmHistoryItem.Builder, AlarmHistoryItem> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlarmHistoryItem::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AlarmHistoryItem::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> HISTORY_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlarmHistoryItem::historyItemTypeAsString)).setter(setter(Builder::historyItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryItemType").build()).build();

    private static final SdkField<String> HISTORY_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlarmHistoryItem::historySummary)).setter(setter(Builder::historySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistorySummary").build()).build();

    private static final SdkField<String> HISTORY_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlarmHistoryItem::historyData)).setter(setter(Builder::historyData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            TIMESTAMP_FIELD, HISTORY_ITEM_TYPE_FIELD, HISTORY_SUMMARY_FIELD, HISTORY_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmName;

    private final Instant timestamp;

    private final String historyItemType;

    private final String historySummary;

    private final String historyData;

    private AlarmHistoryItem(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.timestamp = builder.timestamp;
        this.historyItemType = builder.historyItemType;
        this.historySummary = builder.historySummary;
        this.historyData = builder.historyData;
    }

    /**
     * <p>
     * The descriptive name for the alarm.
     * </p>
     * 
     * @return The descriptive name for the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The time stamp for the alarm history item.
     * </p>
     * 
     * @return The time stamp for the alarm history item.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of alarm history item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeAsString}.
     * </p>
     * 
     * @return The type of alarm history item.
     * @see HistoryItemType
     */
    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(historyItemType);
    }

    /**
     * <p>
     * The type of alarm history item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #historyItemType}
     * will return {@link HistoryItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #historyItemTypeAsString}.
     * </p>
     * 
     * @return The type of alarm history item.
     * @see HistoryItemType
     */
    public String historyItemTypeAsString() {
        return historyItemType;
    }

    /**
     * <p>
     * A summary of the alarm history, in text format.
     * </p>
     * 
     * @return A summary of the alarm history, in text format.
     */
    public String historySummary() {
        return historySummary;
    }

    /**
     * <p>
     * Data about the alarm, in JSON format.
     * </p>
     * 
     * @return Data about the alarm, in JSON format.
     */
    public String historyData() {
        return historyData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(historyItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(historySummary());
        hashCode = 31 * hashCode + Objects.hashCode(historyData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmHistoryItem)) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(historyItemTypeAsString(), other.historyItemTypeAsString())
                && Objects.equals(historySummary(), other.historySummary()) && Objects.equals(historyData(), other.historyData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AlarmHistoryItem").add("AlarmName", alarmName()).add("Timestamp", timestamp())
                .add("HistoryItemType", historyItemTypeAsString()).add("HistorySummary", historySummary())
                .add("HistoryData", historyData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "HistoryItemType":
            return Optional.ofNullable(clazz.cast(historyItemTypeAsString()));
        case "HistorySummary":
            return Optional.ofNullable(clazz.cast(historySummary()));
        case "HistoryData":
            return Optional.ofNullable(clazz.cast(historyData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmHistoryItem, T> g) {
        return obj -> g.apply((AlarmHistoryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmHistoryItem> {
        /**
         * <p>
         * The descriptive name for the alarm.
         * </p>
         * 
         * @param alarmName
         *        The descriptive name for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The time stamp for the alarm history item.
         * </p>
         * 
         * @param timestamp
         *        The time stamp for the alarm history item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of alarm history item.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm history item.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(String historyItemType);

        /**
         * <p>
         * The type of alarm history item.
         * </p>
         * 
         * @param historyItemType
         *        The type of alarm history item.
         * @see HistoryItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoryItemType
         */
        Builder historyItemType(HistoryItemType historyItemType);

        /**
         * <p>
         * A summary of the alarm history, in text format.
         * </p>
         * 
         * @param historySummary
         *        A summary of the alarm history, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historySummary(String historySummary);

        /**
         * <p>
         * Data about the alarm, in JSON format.
         * </p>
         * 
         * @param historyData
         *        Data about the alarm, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyData(String historyData);
    }

    static final class BuilderImpl implements Builder {
        private String alarmName;

        private Instant timestamp;

        private String historyItemType;

        private String historySummary;

        private String historyData;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmHistoryItem model) {
            alarmName(model.alarmName);
            timestamp(model.timestamp);
            historyItemType(model.historyItemType);
            historySummary(model.historySummary);
            historyData(model.historyData);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getHistoryItemTypeAsString() {
            return historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType == null ? null : historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final String getHistorySummary() {
            return historySummary;
        }

        @Override
        public final Builder historySummary(String historySummary) {
            this.historySummary = historySummary;
            return this;
        }

        public final void setHistorySummary(String historySummary) {
            this.historySummary = historySummary;
        }

        public final String getHistoryData() {
            return historyData;
        }

        @Override
        public final Builder historyData(String historyData) {
            this.historyData = historyData;
            return this;
        }

        public final void setHistoryData(String historyData) {
            this.historyData = historyData;
        }

        @Override
        public AlarmHistoryItem build() {
            return new AlarmHistoryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
