/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One data point from the metric time series returned in a Contributor Insights rule report.
 * </p>
 * <p>
 * For more information, see <a>GetInsightRuleReport</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightRuleMetricDatapoint implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightRuleMetricDatapoint.Builder, InsightRuleMetricDatapoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InsightRuleMetricDatapoint::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Double> UNIQUE_CONTRIBUTORS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::uniqueContributors)).setter(setter(Builder::uniqueContributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueContributors").build())
            .build();

    private static final SdkField<Double> MAX_CONTRIBUTOR_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::maxContributorValue)).setter(setter(Builder::maxContributorValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContributorValue").build())
            .build();

    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::sampleCount)).setter(setter(Builder::sampleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleCount").build()).build();

    private static final SdkField<Double> AVERAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Average").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(InsightRuleMetricDatapoint::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            UNIQUE_CONTRIBUTORS_FIELD, MAX_CONTRIBUTOR_VALUE_FIELD, SAMPLE_COUNT_FIELD, AVERAGE_FIELD, SUM_FIELD, MINIMUM_FIELD,
            MAXIMUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final Double uniqueContributors;

    private final Double maxContributorValue;

    private final Double sampleCount;

    private final Double average;

    private final Double sum;

    private final Double minimum;

    private final Double maximum;

    private InsightRuleMetricDatapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.uniqueContributors = builder.uniqueContributors;
        this.maxContributorValue = builder.maxContributorValue;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * The timestamp of the data point.
     * </p>
     * 
     * @return The timestamp of the data point.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of unique contributors who published data during this timestamp.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The number of unique contributors who published data during this timestamp.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double uniqueContributors() {
        return uniqueContributors;
    }

    /**
     * <p>
     * The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately, so
     * the identity of the max contributor could be different for each timestamp.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated
     *         separately, so the identity of the max contributor could be different for each timestamp.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double maxContributorValue() {
        return maxContributorValue;
    }

    /**
     * <p>
     * The number of occurrences that matched the rule during this data point.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The number of occurrences that matched the rule during this data point.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The average value from all contributors during the time period represented by that data point.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The average value from all contributors during the time period represented by that data point.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The sum of the values from all contributors during the time period represented by that data point.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The sum of the values from all contributors during the time period represented by that data point.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The minimum value from a single contributor during the time period represented by that data point.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The minimum value from a single contributor during the time period represented by that data point.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum value from a single occurence from a single contributor during the time period represented by that
     * data point.
     * </p>
     * <p>
     * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     * </p>
     * 
     * @return The maximum value from a single occurence from a single contributor during the time period represented by
     *         that data point.</p>
     *         <p>
     *         This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
     */
    public Double maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueContributors());
        hashCode = 31 * hashCode + Objects.hashCode(maxContributorValue());
        hashCode = 31 * hashCode + Objects.hashCode(sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRuleMetricDatapoint)) {
            return false;
        }
        InsightRuleMetricDatapoint other = (InsightRuleMetricDatapoint) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(uniqueContributors(), other.uniqueContributors())
                && Objects.equals(maxContributorValue(), other.maxContributorValue())
                && Objects.equals(sampleCount(), other.sampleCount()) && Objects.equals(average(), other.average())
                && Objects.equals(sum(), other.sum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(maximum(), other.maximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InsightRuleMetricDatapoint").add("Timestamp", timestamp())
                .add("UniqueContributors", uniqueContributors()).add("MaxContributorValue", maxContributorValue())
                .add("SampleCount", sampleCount()).add("Average", average()).add("Sum", sum()).add("Minimum", minimum())
                .add("Maximum", maximum()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "UniqueContributors":
            return Optional.ofNullable(clazz.cast(uniqueContributors()));
        case "MaxContributorValue":
            return Optional.ofNullable(clazz.cast(maxContributorValue()));
        case "SampleCount":
            return Optional.ofNullable(clazz.cast(sampleCount()));
        case "Average":
            return Optional.ofNullable(clazz.cast(average()));
        case "Sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightRuleMetricDatapoint, T> g) {
        return obj -> g.apply((InsightRuleMetricDatapoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightRuleMetricDatapoint> {
        /**
         * <p>
         * The timestamp of the data point.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The number of unique contributors who published data during this timestamp.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param uniqueContributors
         *        The number of unique contributors who published data during this timestamp.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueContributors(Double uniqueContributors);

        /**
         * <p>
         * The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately,
         * so the identity of the max contributor could be different for each timestamp.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param maxContributorValue
         *        The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated
         *        separately, so the identity of the max contributor could be different for each timestamp.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxContributorValue(Double maxContributorValue);

        /**
         * <p>
         * The number of occurrences that matched the rule during this data point.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param sampleCount
         *        The number of occurrences that matched the rule during this data point.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The average value from all contributors during the time period represented by that data point.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param average
         *        The average value from all contributors during the time period represented by that data point.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The sum of the values from all contributors during the time period represented by that data point.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param sum
         *        The sum of the values from all contributors during the time period represented by that data point.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The minimum value from a single contributor during the time period represented by that data point.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param minimum
         *        The minimum value from a single contributor during the time period represented by that data point.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum value from a single occurence from a single contributor during the time period represented by
         * that data point.
         * </p>
         * <p>
         * This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * </p>
         * 
         * @param maximum
         *        The maximum value from a single occurence from a single contributor during the time period represented
         *        by that data point.</p>
         *        <p>
         *        This statistic is returned only if you included it in the <code>Metrics</code> array in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private Double uniqueContributors;

        private Double maxContributorValue;

        private Double sampleCount;

        private Double average;

        private Double sum;

        private Double minimum;

        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRuleMetricDatapoint model) {
            timestamp(model.timestamp);
            uniqueContributors(model.uniqueContributors);
            maxContributorValue(model.maxContributorValue);
            sampleCount(model.sampleCount);
            average(model.average);
            sum(model.sum);
            minimum(model.minimum);
            maximum(model.maximum);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getUniqueContributors() {
            return uniqueContributors;
        }

        @Override
        public final Builder uniqueContributors(Double uniqueContributors) {
            this.uniqueContributors = uniqueContributors;
            return this;
        }

        public final void setUniqueContributors(Double uniqueContributors) {
            this.uniqueContributors = uniqueContributors;
        }

        public final Double getMaxContributorValue() {
            return maxContributorValue;
        }

        @Override
        public final Builder maxContributorValue(Double maxContributorValue) {
            this.maxContributorValue = maxContributorValue;
            return this;
        }

        public final void setMaxContributorValue(Double maxContributorValue) {
            this.maxContributorValue = maxContributorValue;
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public InsightRuleMetricDatapoint build() {
            return new InsightRuleMetricDatapoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
