/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashboardResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetDashboardResponse.Builder, GetDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDashboardResponse::dashboardArn)).setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<String> DASHBOARD_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDashboardResponse::dashboardBody)).setter(setter(Builder::dashboardBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardBody").build()).build();

    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDashboardResponse::dashboardName)).setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD,
            DASHBOARD_BODY_FIELD, DASHBOARD_NAME_FIELD));

    private final String dashboardArn;

    private final String dashboardBody;

    private final String dashboardName;

    private GetDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.dashboardBody = builder.dashboardBody;
        this.dashboardName = builder.dashboardName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The detailed information about the dashboard, including what widgets are included and their location on the
     * dashboard. For more information about the <code>DashboardBody</code> syntax, see
     * <a>CloudWatch-Dashboard-Body-Structure</a>.
     * </p>
     * 
     * @return The detailed information about the dashboard, including what widgets are included and their location on
     *         the dashboard. For more information about the <code>DashboardBody</code> syntax, see
     *         <a>CloudWatch-Dashboard-Body-Structure</a>.
     */
    public String dashboardBody() {
        return dashboardBody;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public String dashboardName() {
        return dashboardName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardBody());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardResponse)) {
            return false;
        }
        GetDashboardResponse other = (GetDashboardResponse) obj;
        return Objects.equals(dashboardArn(), other.dashboardArn()) && Objects.equals(dashboardBody(), other.dashboardBody())
                && Objects.equals(dashboardName(), other.dashboardName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDashboardResponse").add("DashboardArn", dashboardArn()).add("DashboardBody", dashboardBody())
                .add("DashboardName", dashboardName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "DashboardBody":
            return Optional.ofNullable(clazz.cast(dashboardBody()));
        case "DashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardResponse, T> g) {
        return obj -> g.apply((GetDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDashboardResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The detailed information about the dashboard, including what widgets are included and their location on the
         * dashboard. For more information about the <code>DashboardBody</code> syntax, see
         * <a>CloudWatch-Dashboard-Body-Structure</a>.
         * </p>
         * 
         * @param dashboardBody
         *        The detailed information about the dashboard, including what widgets are included and their location
         *        on the dashboard. For more information about the <code>DashboardBody</code> syntax, see
         *        <a>CloudWatch-Dashboard-Body-Structure</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardBody(String dashboardBody);

        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private String dashboardArn;

        private String dashboardBody;

        private String dashboardName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardResponse model) {
            super(model);
            dashboardArn(model.dashboardArn);
            dashboardBody(model.dashboardBody);
            dashboardName(model.dashboardName);
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final String getDashboardBody() {
            return dashboardBody;
        }

        @Override
        public final Builder dashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
            return this;
        }

        public final void setDashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        public GetDashboardResponse build() {
            return new GetDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
