/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInsightRuleRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutInsightRuleRequest.Builder, PutInsightRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInsightRuleRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInsightRuleRequest::ruleState)).setter(setter(Builder::ruleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleState").build()).build();

    private static final SdkField<String> RULE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInsightRuleRequest::ruleDefinition)).setter(setter(Builder::ruleDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_STATE_FIELD, RULE_DEFINITION_FIELD));

    private final String ruleName;

    private final String ruleState;

    private final String ruleDefinition;

    private PutInsightRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleState = builder.ruleState;
        this.ruleDefinition = builder.ruleDefinition;
    }

    /**
     * <p>
     * A unique name for the rule.
     * </p>
     * 
     * @return A unique name for the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The state of the rule. Valid values are ENABLED and DISABLED.
     * </p>
     * 
     * @return The state of the rule. Valid values are ENABLED and DISABLED.
     */
    public String ruleState() {
        return ruleState;
    }

    /**
     * <p>
     * The definition of the rule, as a JSON object. For details on the valid syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     * >Contributor Insights Rule Syntax</a>.
     * </p>
     * 
     * @return The definition of the rule, as a JSON object. For details on the valid syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     *         >Contributor Insights Rule Syntax</a>.
     */
    public String ruleDefinition() {
        return ruleDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleState());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightRuleRequest)) {
            return false;
        }
        PutInsightRuleRequest other = (PutInsightRuleRequest) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleState(), other.ruleState())
                && Objects.equals(ruleDefinition(), other.ruleDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutInsightRuleRequest").add("RuleName", ruleName()).add("RuleState", ruleState())
                .add("RuleDefinition", ruleDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleState":
            return Optional.ofNullable(clazz.cast(ruleState()));
        case "RuleDefinition":
            return Optional.ofNullable(clazz.cast(ruleDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightRuleRequest, T> g) {
        return obj -> g.apply((PutInsightRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutInsightRuleRequest> {
        /**
         * <p>
         * A unique name for the rule.
         * </p>
         * 
         * @param ruleName
         *        A unique name for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The state of the rule. Valid values are ENABLED and DISABLED.
         * </p>
         * 
         * @param ruleState
         *        The state of the rule. Valid values are ENABLED and DISABLED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleState(String ruleState);

        /**
         * <p>
         * The definition of the rule, as a JSON object. For details on the valid syntax, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         * >Contributor Insights Rule Syntax</a>.
         * </p>
         * 
         * @param ruleDefinition
         *        The definition of the rule, as a JSON object. For details on the valid syntax, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         *        >Contributor Insights Rule Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinition(String ruleDefinition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String ruleName;

        private String ruleState;

        private String ruleDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightRuleRequest model) {
            super(model);
            ruleName(model.ruleName);
            ruleState(model.ruleState);
            ruleDefinition(model.ruleDefinition);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleState() {
            return ruleState;
        }

        @Override
        public final Builder ruleState(String ruleState) {
            this.ruleState = ruleState;
            return this;
        }

        public final void setRuleState(String ruleState) {
            this.ruleState = ruleState;
        }

        public final String getRuleDefinition() {
            return ruleDefinition;
        }

        @Override
        public final Builder ruleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
            return this;
        }

        public final void setRuleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightRuleRequest build() {
            return new PutInsightRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
