/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardEntry implements SdkPojo, Serializable, ToCopyableBuilder<DashboardEntry.Builder, DashboardEntry> {
    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardEntry::dashboardName)).setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()).build();

    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardEntry::dashboardArn)).setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DashboardEntry::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DashboardEntry::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAME_FIELD,
            DASHBOARD_ARN_FIELD, LAST_MODIFIED_FIELD, SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dashboardName;

    private final String dashboardArn;

    private final Instant lastModified;

    private final Long size;

    private DashboardEntry(BuilderImpl builder) {
        this.dashboardName = builder.dashboardName;
        this.dashboardArn = builder.dashboardArn;
        this.lastModified = builder.lastModified;
        this.size = builder.size;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The time stamp of when the dashboard was last modified, either by an API call or through the console. This number
     * is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time stamp of when the dashboard was last modified, either by an API call or through the console.
     *         This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The size of the dashboard, in bytes.
     * </p>
     * 
     * @return The size of the dashboard, in bytes.
     */
    public Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardEntry)) {
            return false;
        }
        DashboardEntry other = (DashboardEntry) obj;
        return Objects.equals(dashboardName(), other.dashboardName()) && Objects.equals(dashboardArn(), other.dashboardArn())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashboardEntry").add("DashboardName", dashboardName()).add("DashboardArn", dashboardArn())
                .add("LastModified", lastModified()).add("Size", size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardEntry, T> g) {
        return obj -> g.apply((DashboardEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardEntry> {
        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The time stamp of when the dashboard was last modified, either by an API call or through the console. This
         * number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param lastModified
         *        The time stamp of when the dashboard was last modified, either by an API call or through the console.
         *        This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The size of the dashboard, in bytes.
         * </p>
         * 
         * @param size
         *        The size of the dashboard, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    static final class BuilderImpl implements Builder {
        private String dashboardName;

        private String dashboardArn;

        private Instant lastModified;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardEntry model) {
            dashboardName(model.dashboardName);
            dashboardArn(model.dashboardArn);
            lastModified(model.lastModified);
            size(model.size);
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public DashboardEntry build() {
            return new DashboardEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
