/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetMetricDataResponse.Builder, GetMetricDataResponse> {
    private static final SdkField<List<MetricDataResult>> METRIC_DATA_RESULTS_FIELD = SdkField
            .<List<MetricDataResult>> builder(MarshallingType.LIST)
            .getter(getter(GetMetricDataResponse::metricDataResults))
            .setter(setter(Builder::metricDataResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMetricDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MessageData>> MESSAGES_FIELD = SdkField
            .<List<MessageData>> builder(MarshallingType.LIST)
            .getter(getter(GetMetricDataResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageData> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, MESSAGES_FIELD));

    private final List<MetricDataResult> metricDataResults;

    private final String nextToken;

    private final List<MessageData> messages;

    private GetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricDataResults = builder.metricDataResults;
        this.nextToken = builder.nextToken;
        this.messages = builder.messages;
    }

    /**
     * Returns true if the MetricDataResults property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMetricDataResults() {
        return metricDataResults != null && !(metricDataResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics that are returned, including the metric name, namespace, and dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricDataResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metrics that are returned, including the metric name, namespace, and dimensions.
     */
    public List<MetricDataResult> metricDataResults() {
        return metricDataResults;
    }

    /**
     * <p>
     * A token that marks the next batch of returned results.
     * </p>
     * 
     * @return A token that marks the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Messages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a message.
     * An example of a message that might be returned is <code>Maximum number of allowed metrics exceeded</code>. If
     * there is a message, as much of the operation as possible is still executed.
     * </p>
     * <p>
     * A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any message
     * about a specific metric returned by the operation appears in the <code>MetricDataResult</code> object returned
     * for that metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMessages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
     *         message. An example of a message that might be returned is
     *         <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the operation
     *         as possible is still executed.</p>
     *         <p>
     *         A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any
     *         message about a specific metric returned by the operation appears in the <code>MetricDataResult</code>
     *         object returned for that metric.
     */
    public List<MessageData> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricDataResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataResponse)) {
            return false;
        }
        GetMetricDataResponse other = (GetMetricDataResponse) obj;
        return Objects.equals(metricDataResults(), other.metricDataResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMetricDataResponse").add("MetricDataResults", metricDataResults())
                .add("NextToken", nextToken()).add("Messages", messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricDataResults":
            return Optional.ofNullable(clazz.cast(metricDataResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataResponse, T> g) {
        return obj -> g.apply((GetMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataResponse> {
        /**
         * <p>
         * The metrics that are returned, including the metric name, namespace, and dimensions.
         * </p>
         * 
         * @param metricDataResults
         *        The metrics that are returned, including the metric name, namespace, and dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataResults(Collection<MetricDataResult> metricDataResults);

        /**
         * <p>
         * The metrics that are returned, including the metric name, namespace, and dimensions.
         * </p>
         * 
         * @param metricDataResults
         *        The metrics that are returned, including the metric name, namespace, and dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataResults(MetricDataResult... metricDataResults);

        /**
         * <p>
         * The metrics that are returned, including the metric name, namespace, and dimensions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDataResult>.Builder} avoiding the
         * need to create one manually via {@link List<MetricDataResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDataResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricDataResults(List<MetricDataResult>)}.
         * 
         * @param metricDataResults
         *        a consumer that will call methods on {@link List<MetricDataResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataResults(List<MetricDataResult>)
         */
        Builder metricDataResults(Consumer<MetricDataResult.Builder>... metricDataResults);

        /**
         * <p>
         * A token that marks the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        A token that marks the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
         * message. An example of a message that might be returned is
         * <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the operation as
         * possible is still executed.
         * </p>
         * <p>
         * A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any message
         * about a specific metric returned by the operation appears in the <code>MetricDataResult</code> object
         * returned for that metric.
         * </p>
         * 
         * @param messages
         *        Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
         *        message. An example of a message that might be returned is
         *        <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the
         *        operation as possible is still executed.</p>
         *        <p>
         *        A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any
         *        message about a specific metric returned by the operation appears in the <code>MetricDataResult</code>
         *        object returned for that metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<MessageData> messages);

        /**
         * <p>
         * Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
         * message. An example of a message that might be returned is
         * <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the operation as
         * possible is still executed.
         * </p>
         * <p>
         * A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any message
         * about a specific metric returned by the operation appears in the <code>MetricDataResult</code> object
         * returned for that metric.
         * </p>
         * 
         * @param messages
         *        Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
         *        message. An example of a message that might be returned is
         *        <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the
         *        operation as possible is still executed.</p>
         *        <p>
         *        A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any
         *        message about a specific metric returned by the operation appears in the <code>MetricDataResult</code>
         *        object returned for that metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(MessageData... messages);

        /**
         * <p>
         * Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a
         * message. An example of a message that might be returned is
         * <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the operation as
         * possible is still executed.
         * </p>
         * <p>
         * A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any message
         * about a specific metric returned by the operation appears in the <code>MetricDataResult</code> object
         * returned for that metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MessageData>.Builder} avoiding the need to
         * create one manually via {@link List<MessageData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MessageData>.Builder#build()} is called immediately and its
         * result is passed to {@link #messages(List<MessageData>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link List<MessageData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(List<MessageData>)
         */
        Builder messages(Consumer<MessageData.Builder>... messages);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<MetricDataResult> metricDataResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<MessageData> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataResponse model) {
            super(model);
            metricDataResults(model.metricDataResults);
            nextToken(model.nextToken);
            messages(model.messages);
        }

        public final Collection<MetricDataResult.Builder> getMetricDataResults() {
            return metricDataResults != null ? metricDataResults.stream().map(MetricDataResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDataResults(Collection<MetricDataResult> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copy(metricDataResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(MetricDataResult... metricDataResults) {
            metricDataResults(Arrays.asList(metricDataResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(Consumer<MetricDataResult.Builder>... metricDataResults) {
            metricDataResults(Stream.of(metricDataResults).map(c -> MetricDataResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDataResults(Collection<MetricDataResult.BuilderImpl> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copyFromBuilder(metricDataResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<MessageData.Builder> getMessages() {
            return messages != null ? messages.stream().map(MessageData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<MessageData> messages) {
            this.messages = MetricDataResultMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(MessageData... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<MessageData.Builder>... messages) {
            messages(Stream.of(messages).map(c -> MessageData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<MessageData.BuilderImpl> messages) {
            this.messages = MetricDataResultMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public GetMetricDataResponse build() {
            return new GetMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
