/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about a composite alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeAlarm implements SdkPojo, Serializable, ToCopyableBuilder<CompositeAlarm.Builder, CompositeAlarm> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActionsEnabled").getter(getter(CompositeAlarm::actionsEnabled)).setter(setter(Builder::actionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()).build();

    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmActions")
            .getter(getter(CompositeAlarm::alarmActions))
            .setter(setter(Builder::alarmActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmArn").getter(getter(CompositeAlarm::alarmArn)).setter(setter(Builder::alarmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()).build();

    private static final SdkField<Instant> ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AlarmConfigurationUpdatedTimestamp")
            .getter(getter(CompositeAlarm::alarmConfigurationUpdatedTimestamp))
            .setter(setter(Builder::alarmConfigurationUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfigurationUpdatedTimestamp")
                    .build()).build();

    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmDescription").getter(getter(CompositeAlarm::alarmDescription))
            .setter(setter(Builder::alarmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()).build();

    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmName").getter(getter(CompositeAlarm::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> ALARM_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmRule").getter(getter(CompositeAlarm::alarmRule)).setter(setter(Builder::alarmRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmRule").build()).build();

    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsufficientDataActions")
            .getter(getter(CompositeAlarm::insufficientDataActions))
            .setter(setter(Builder::insufficientDataActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OKActions")
            .getter(getter(CompositeAlarm::okActions))
            .setter(setter(Builder::okActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(CompositeAlarm::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonData").getter(getter(CompositeAlarm::stateReasonData))
            .setter(setter(Builder::stateReasonData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()).build();

    private static final SdkField<Instant> STATE_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateUpdatedTimestamp").getter(getter(CompositeAlarm::stateUpdatedTimestamp))
            .setter(setter(Builder::stateUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateValue").getter(getter(CompositeAlarm::stateValueAsString)).setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD,
            ALARM_ACTIONS_FIELD, ALARM_ARN_FIELD, ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD, ALARM_DESCRIPTION_FIELD,
            ALARM_NAME_FIELD, ALARM_RULE_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, OK_ACTIONS_FIELD, STATE_REASON_FIELD,
            STATE_REASON_DATA_FIELD, STATE_UPDATED_TIMESTAMP_FIELD, STATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean actionsEnabled;

    private final List<String> alarmActions;

    private final String alarmArn;

    private final Instant alarmConfigurationUpdatedTimestamp;

    private final String alarmDescription;

    private final String alarmName;

    private final String alarmRule;

    private final List<String> insufficientDataActions;

    private final List<String> okActions;

    private final String stateReason;

    private final String stateReasonData;

    private final Instant stateUpdatedTimestamp;

    private final String stateValue;

    private CompositeAlarm(BuilderImpl builder) {
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmArn = builder.alarmArn;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.alarmRule = builder.alarmRule;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.okActions = builder.okActions;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
        this.stateUpdatedTimestamp = builder.stateUpdatedTimestamp;
        this.stateValue = builder.stateValue;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state.
     */
    public Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * Returns true if the AlarmActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAlarmActions() {
        return alarmActions != null && !(alarmActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is
     * specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlarmActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the ALARM state from any other state. Each action
     *         is specified as an Amazon Resource Name (ARN).
     */
    public List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alarm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alarm.
     */
    public String alarmArn() {
        return alarmArn;
    }

    /**
     * <p>
     * The time stamp of the last update to the alarm configuration.
     * </p>
     * 
     * @return The time stamp of the last update to the alarm configuration.
     */
    public Instant alarmConfigurationUpdatedTimestamp() {
        return alarmConfigurationUpdatedTimestamp;
    }

    /**
     * <p>
     * The description of the alarm.
     * </p>
     * 
     * @return The description of the alarm.
     */
    public String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The rule that this alarm uses to evaluate its alarm state.
     * </p>
     * 
     * @return The rule that this alarm uses to evaluate its alarm state.
     */
    public String alarmRule() {
        return alarmRule;
    }

    /**
     * Returns true if the InsufficientDataActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInsufficientDataActions() {
        return insufficientDataActions != null && !(insufficientDataActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each
     * action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInsufficientDataActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).
     */
    public List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * Returns true if the OKActions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOkActions() {
        return okActions != null && !(okActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified
     * as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOkActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the OK state from any other state. Each action is
     *         specified as an Amazon Resource Name (ARN).
     */
    public List<String> okActions() {
        return okActions;
    }

    /**
     * <p>
     * An explanation for the alarm state, in text format.
     * </p>
     * 
     * @return An explanation for the alarm state, in text format.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * An explanation for the alarm state, in JSON format.
     * </p>
     * 
     * @return An explanation for the alarm state, in JSON format.
     */
    public String stateReasonData() {
        return stateReasonData;
    }

    /**
     * <p>
     * The time stamp of the last update to the alarm state.
     * </p>
     * 
     * @return The time stamp of the last update to the alarm state.
     */
    public Instant stateUpdatedTimestamp() {
        return stateUpdatedTimestamp;
    }

    /**
     * <p>
     * The state value for the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value for the alarm.
     * @see StateValue
     */
    public StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The state value for the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value for the alarm.
     * @see StateValue
     */
    public String stateValueAsString() {
        return stateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmActions() ? alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsufficientDataActions() ? insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOkActions() ? okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonData());
        hashCode = 31 * hashCode + Objects.hashCode(stateUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeAlarm)) {
            return false;
        }
        CompositeAlarm other = (CompositeAlarm) obj;
        return Objects.equals(actionsEnabled(), other.actionsEnabled()) && hasAlarmActions() == other.hasAlarmActions()
                && Objects.equals(alarmActions(), other.alarmActions()) && Objects.equals(alarmArn(), other.alarmArn())
                && Objects.equals(alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp())
                && Objects.equals(alarmDescription(), other.alarmDescription()) && Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(alarmRule(), other.alarmRule())
                && hasInsufficientDataActions() == other.hasInsufficientDataActions()
                && Objects.equals(insufficientDataActions(), other.insufficientDataActions())
                && hasOkActions() == other.hasOkActions() && Objects.equals(okActions(), other.okActions())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonData(), other.stateReasonData())
                && Objects.equals(stateUpdatedTimestamp(), other.stateUpdatedTimestamp())
                && Objects.equals(stateValueAsString(), other.stateValueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CompositeAlarm").add("ActionsEnabled", actionsEnabled())
                .add("AlarmActions", hasAlarmActions() ? alarmActions() : null).add("AlarmArn", alarmArn())
                .add("AlarmConfigurationUpdatedTimestamp", alarmConfigurationUpdatedTimestamp())
                .add("AlarmDescription", alarmDescription()).add("AlarmName", alarmName()).add("AlarmRule", alarmRule())
                .add("InsufficientDataActions", hasInsufficientDataActions() ? insufficientDataActions() : null)
                .add("OKActions", hasOkActions() ? okActions() : null).add("StateReason", stateReason())
                .add("StateReasonData", stateReasonData()).add("StateUpdatedTimestamp", stateUpdatedTimestamp())
                .add("StateValue", stateValueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionsEnabled":
            return Optional.ofNullable(clazz.cast(actionsEnabled()));
        case "AlarmActions":
            return Optional.ofNullable(clazz.cast(alarmActions()));
        case "AlarmArn":
            return Optional.ofNullable(clazz.cast(alarmArn()));
        case "AlarmConfigurationUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(alarmConfigurationUpdatedTimestamp()));
        case "AlarmDescription":
            return Optional.ofNullable(clazz.cast(alarmDescription()));
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "AlarmRule":
            return Optional.ofNullable(clazz.cast(alarmRule()));
        case "InsufficientDataActions":
            return Optional.ofNullable(clazz.cast(insufficientDataActions()));
        case "OKActions":
            return Optional.ofNullable(clazz.cast(okActions()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonData":
            return Optional.ofNullable(clazz.cast(stateReasonData()));
        case "StateUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(stateUpdatedTimestamp()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositeAlarm, T> g) {
        return obj -> g.apply((CompositeAlarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeAlarm> {
        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is
         * specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the ALARM state from any other state. Each
         *        action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is
         * specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the ALARM state from any other state. Each
         *        action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alarm.
         * </p>
         * 
         * @param alarmArn
         *        The Amazon Resource Name (ARN) of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmArn(String alarmArn);

        /**
         * <p>
         * The time stamp of the last update to the alarm configuration.
         * </p>
         * 
         * @param alarmConfigurationUpdatedTimestamp
         *        The time stamp of the last update to the alarm configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp);

        /**
         * <p>
         * The description of the alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The rule that this alarm uses to evaluate its alarm state.
         * </p>
         * 
         * @param alarmRule
         *        The rule that this alarm uses to evaluate its alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRule(String alarmRule);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the OK state from any other state. Each action is
         * specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the OK state from any other state. Each action
         *        is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the OK state from any other state. Each action is
         * specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the OK state from any other state. Each action
         *        is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * An explanation for the alarm state, in text format.
         * </p>
         * 
         * @param stateReason
         *        An explanation for the alarm state, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * An explanation for the alarm state, in JSON format.
         * </p>
         * 
         * @param stateReasonData
         *        An explanation for the alarm state, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReasonData(String stateReasonData);

        /**
         * <p>
         * The time stamp of the last update to the alarm state.
         * </p>
         * 
         * @param stateUpdatedTimestamp
         *        The time stamp of the last update to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp);

        /**
         * <p>
         * The state value for the alarm.
         * </p>
         * 
         * @param stateValue
         *        The state value for the alarm.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The state value for the alarm.
         * </p>
         * 
         * @param stateValue
         *        The state value for the alarm.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean actionsEnabled;

        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private String alarmArn;

        private Instant alarmConfigurationUpdatedTimestamp;

        private String alarmDescription;

        private String alarmName;

        private String alarmRule;

        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();

        private String stateReason;

        private String stateReasonData;

        private Instant stateUpdatedTimestamp;

        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeAlarm model) {
            actionsEnabled(model.actionsEnabled);
            alarmActions(model.alarmActions);
            alarmArn(model.alarmArn);
            alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            alarmDescription(model.alarmDescription);
            alarmName(model.alarmName);
            alarmRule(model.alarmRule);
            insufficientDataActions(model.insufficientDataActions);
            okActions(model.okActions);
            stateReason(model.stateReason);
            stateReasonData(model.stateReasonData);
            stateUpdatedTimestamp(model.stateUpdatedTimestamp);
            stateValue(model.stateValue);
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getAlarmActions() {
            if (alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        public final String getAlarmArn() {
            return alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        public final Instant getAlarmConfigurationUpdatedTimestamp() {
            return alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmRule() {
            return alarmRule;
        }

        @Override
        public final Builder alarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final void setAlarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        public final Collection<String> getOkActions() {
            if (okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        public final Instant getStateUpdatedTimestamp() {
            return stateUpdatedTimestamp;
        }

        @Override
        public final Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
            return this;
        }

        public final void setStateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public CompositeAlarm build() {
            return new CompositeAlarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
