/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableInsightRulesRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DisableInsightRulesRequest.Builder, DisableInsightRulesRequest> {
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleNames")
            .getter(getter(DisableInsightRulesRequest::ruleNames))
            .setter(setter(Builder::ruleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAMES_FIELD));

    private final List<String> ruleNames;

    private DisableInsightRulesRequest(BuilderImpl builder) {
        super(builder);
        this.ruleNames = builder.ruleNames;
    }

    /**
     * Returns true if the RuleNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuleNames() {
        return ruleNames != null && !(ruleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the rule names to disable. If you need to find out the names of your rules, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
     * >DescribeInsightRules</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of the rule names to disable. If you need to find out the names of your rules, use <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
     *         >DescribeInsightRules</a>.
     */
    public List<String> ruleNames() {
        return ruleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleNames() ? ruleNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableInsightRulesRequest)) {
            return false;
        }
        DisableInsightRulesRequest other = (DisableInsightRulesRequest) obj;
        return hasRuleNames() == other.hasRuleNames() && Objects.equals(ruleNames(), other.ruleNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableInsightRulesRequest").add("RuleNames", hasRuleNames() ? ruleNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleNames":
            return Optional.ofNullable(clazz.cast(ruleNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableInsightRulesRequest, T> g) {
        return obj -> g.apply((DisableInsightRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisableInsightRulesRequest> {
        /**
         * <p>
         * An array of the rule names to disable. If you need to find out the names of your rules, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         * >DescribeInsightRules</a>.
         * </p>
         * 
         * @param ruleNames
         *        An array of the rule names to disable. If you need to find out the names of your rules, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         *        >DescribeInsightRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(Collection<String> ruleNames);

        /**
         * <p>
         * An array of the rule names to disable. If you need to find out the names of your rules, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         * >DescribeInsightRules</a>.
         * </p>
         * 
         * @param ruleNames
         *        An array of the rule names to disable. If you need to find out the names of your rules, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         *        >DescribeInsightRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(String... ruleNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableInsightRulesRequest model) {
            super(model);
            ruleNames(model.ruleNames);
        }

        public final Collection<String> getRuleNames() {
            if (ruleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = InsightRuleNamesCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = InsightRuleNamesCopier.copy(ruleNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableInsightRulesRequest build() {
            return new DisableInsightRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
