/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmsForMetricResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmsForMetricResponse.Builder, DescribeAlarmsForMetricResponse> {
    private static final SdkField<List<MetricAlarm>> METRIC_ALARMS_FIELD = SdkField
            .<List<MetricAlarm>> builder(MarshallingType.LIST)
            .memberName("MetricAlarms")
            .getter(getter(DescribeAlarmsForMetricResponse::metricAlarms))
            .setter(setter(Builder::metricAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ALARMS_FIELD));

    private final List<MetricAlarm> metricAlarms;

    private DescribeAlarmsForMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricAlarms = builder.metricAlarms;
    }

    /**
     * Returns true if the MetricAlarms property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMetricAlarms() {
        return metricAlarms != null && !(metricAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each alarm with the specified metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricAlarms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The information for each alarm with the specified metric.
     */
    public List<MetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricAlarms() ? metricAlarms() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricResponse)) {
            return false;
        }
        DescribeAlarmsForMetricResponse other = (DescribeAlarmsForMetricResponse) obj;
        return hasMetricAlarms() == other.hasMetricAlarms() && Objects.equals(metricAlarms(), other.metricAlarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmsForMetricResponse").add("MetricAlarms", hasMetricAlarms() ? metricAlarms() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricAlarms":
            return Optional.ofNullable(clazz.cast(metricAlarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsForMetricResponse, T> g) {
        return obj -> g.apply((DescribeAlarmsForMetricResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * 
         * @param metricAlarms
         *        The information for each alarm with the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<MetricAlarm> metricAlarms);

        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * 
         * @param metricAlarms
         *        The information for each alarm with the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(MetricAlarm... metricAlarms);

        /**
         * <p>
         * The information for each alarm with the specified metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricAlarm>.Builder} avoiding the need to
         * create one manually via {@link List<MetricAlarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricAlarm>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricAlarms(List<MetricAlarm>)}.
         * 
         * @param metricAlarms
         *        a consumer that will call methods on {@link List<MetricAlarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAlarms(List<MetricAlarm>)
         */
        Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<MetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricResponse model) {
            super(model);
            metricAlarms(model.metricAlarms);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            if (metricAlarms instanceof SdkAutoConstructList) {
                return null;
            }
            return metricAlarms != null ? metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms) {
            metricAlarms(Stream.of(metricAlarms).map(c -> MetricAlarm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        public DescribeAlarmsForMetricResponse build() {
            return new DescribeAlarmsForMetricResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
