/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricStatisticsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetMetricStatisticsResponse.Builder, GetMetricStatisticsResponse> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(GetMetricStatisticsResponse::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<Datapoint>> DATAPOINTS_FIELD = SdkField
            .<List<Datapoint>> builder(MarshallingType.LIST)
            .memberName("Datapoints")
            .getter(getter(GetMetricStatisticsResponse::datapoints))
            .setter(setter(Builder::datapoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datapoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Datapoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Datapoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LABEL_FIELD, DATAPOINTS_FIELD));

    private final String label;

    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    /**
     * <p>
     * A label for the specified metric.
     * </p>
     * 
     * @return A label for the specified metric.
     */
    public String label() {
        return label;
    }

    /**
     * Returns true if the Datapoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDatapoints() {
        return datapoints != null && !(datapoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data points for the specified metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatapoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data points for the specified metric.
     */
    public List<Datapoint> datapoints() {
        return datapoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(datapoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse) obj;
        return Objects.equals(label(), other.label()) && Objects.equals(datapoints(), other.datapoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMetricStatisticsResponse").add("Label", label()).add("Datapoints", datapoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Datapoints":
            return Optional.ofNullable(clazz.cast(datapoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricStatisticsResponse, T> g) {
        return obj -> g.apply((GetMetricStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        /**
         * <p>
         * A label for the specified metric.
         * </p>
         * 
         * @param label
         *        A label for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Collection<Datapoint> datapoints);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * 
         * @param datapoints
         *        The data points for the specified metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapoints(Datapoint... datapoints);

        /**
         * <p>
         * The data points for the specified metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Datapoint>.Builder} avoiding the need to
         * create one manually via {@link List<Datapoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Datapoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #datapoints(List<Datapoint>)}.
         * 
         * @param datapoints
         *        a consumer that will call methods on {@link List<Datapoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datapoints(List<Datapoint>)
         */
        Builder datapoints(Consumer<Datapoint.Builder>... datapoints);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private String label;

        private List<Datapoint> datapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            super(model);
            label(model.label);
            datapoints(model.datapoints);
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Datapoint.Builder> getDatapoints() {
            return datapoints != null ? datapoints.stream().map(Datapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint... datapoints) {
            datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<Datapoint.Builder>... datapoints) {
            datapoints(Stream.of(datapoints).map(c -> Datapoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatapoints(Collection<Datapoint.BuilderImpl> datapoints) {
            this.datapoints = DatapointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
