/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure is used in both <code>GetMetricData</code> and <code>PutMetricAlarm</code>. The supported use of this
 * structure is different for those two operations.
 * </p>
 * <p>
 * When used in <code>GetMetricData</code>, it indicates the metric data to return, and whether this call is just
 * retrieving a batch set of data for one metric, or is performing a math expression on metric data. A single
 * <code>GetMetricData</code> call can include up to 500 <code>MetricDataQuery</code> structures.
 * </p>
 * <p>
 * When used in <code>PutMetricAlarm</code>, it enables you to create an alarm based on a metric math expression. Each
 * <code>MetricDataQuery</code> in the array specifies either a metric to retrieve, or a math expression to be performed
 * on retrieved metrics. A single <code>PutMetricAlarm</code> call can include up to 20 <code>MetricDataQuery</code>
 * structures in the array. The 20 structures can include as many as 10 structures that contain a
 * <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the
 * <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, one must
 * have <code>True</code> as the value for <code>ReturnData</code>. The result of this expression is the value the alarm
 * watches.
 * </p>
 * <p>
 * Any expression used in a <code>PutMetricAlarm</code> operation must return a single time series. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
 * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 * <p>
 * Some of the parameters of this structure also have different uses whether you are using this structure in a
 * <code>GetMetricData</code> operation or a <code>PutMetricAlarm</code> operation. These differences are explained in
 * the following parameter list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDataQuery implements SdkPojo, Serializable, ToCopyableBuilder<MetricDataQuery.Builder, MetricDataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(MetricDataQuery::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<MetricStat> METRIC_STAT_FIELD = SdkField.<MetricStat> builder(MarshallingType.SDK_POJO)
            .memberName("MetricStat").getter(getter(MetricDataQuery::metricStat)).setter(setter(Builder::metricStat))
            .constructor(MetricStat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(MetricDataQuery::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(MetricDataQuery::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnData").getter(getter(MetricDataQuery::returnData)).setter(setter(Builder::returnData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnData").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(MetricDataQuery::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, METRIC_STAT_FIELD,
            EXPRESSION_FIELD, LABEL_FIELD, RETURN_DATA_FIELD, PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final MetricStat metricStat;

    private final String expression;

    private final String label;

    private final Boolean returnData;

    private final Integer period;

    private MetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.metricStat = builder.metricStat;
        this.expression = builder.expression;
        this.label = builder.label;
        this.returnData = builder.returnData;
        this.period = builder.period;
    }

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This name must be unique within a single
     * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the mathematical expression. The valid characters are
     * letters, numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     * 
     * @return A short name used to tie this object to the results in the response. This name must be unique within a
     *         single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data,
     *         this name represents that data and can serve as a variable in the mathematical expression. The valid
     *         characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is
     * retrieving a metric and not performing a math expression on returned data.
     * </p>
     * <p>
     * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but
     * not both.
     * </p>
     * 
     * @return The metric to be returned, along with statistics, period, and units. Use this parameter only if this
     *         object is retrieving a metric and not performing a math expression on returned data.</p>
     *         <p>
     *         Within one MetricDataQuery object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */
    public final MetricStat metricStat() {
        return metricStat;
    }

    /**
     * <p>
     * The math expression to be performed on the returned data, if this object is performing a math expression. This
     * expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the
     * <code>Id</code> of other expressions to use the result of those expressions. For more information about metric
     * math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
     * but not both.
     * </p>
     * 
     * @return The math expression to be performed on the returned data, if this object is performing a math expression.
     *         This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also
     *         use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     *         about metric math expressions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     *         >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *         <p>
     *         Within each MetricDataQuery object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If Label is omitted, CloudWatch generates a default.
     * </p>
     * 
     * @return A human-readable label for this metric or expression. This is especially useful if this is an expression,
     *         so that you know what the value represents. If the metric or expression is shown in a CloudWatch
     *         dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>False</code>. If you omit this, the default of <code>True</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     * 
     * @return When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw
     *         data values of this metric. If you are performing this call just to do math expressions and do not also
     *         need the raw data returned, you can specify <code>False</code>. If you omit this, the default of
     *         <code>True</code> is used.</p>
     *         <p>
     *         When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use
     *         as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation,
     *         specify <code>ReturnData</code> as False.
     */
    public final Boolean returnData() {
        return returnData;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
     * <code>StorageResolution of 1 second</code>.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period
     *         can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     *         are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple
     *         of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that
     *         includes a <code>StorageResolution of 1 second</code>.
     */
    public final Integer period() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metricStat());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(returnData());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataQuery)) {
            return false;
        }
        MetricDataQuery other = (MetricDataQuery) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(metricStat(), other.metricStat())
                && Objects.equals(expression(), other.expression()) && Objects.equals(label(), other.label())
                && Objects.equals(returnData(), other.returnData()) && Objects.equals(period(), other.period());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDataQuery").add("Id", id()).add("MetricStat", metricStat())
                .add("Expression", expression()).add("Label", label()).add("ReturnData", returnData()).add("Period", period())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MetricStat":
            return Optional.ofNullable(clazz.cast(metricStat()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "ReturnData":
            return Optional.ofNullable(clazz.cast(returnData()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDataQuery, T> g) {
        return obj -> g.apply((MetricDataQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDataQuery> {
        /**
         * <p>
         * A short name used to tie this object to the results in the response. This name must be unique within a single
         * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
         * represents that data and can serve as a variable in the mathematical expression. The valid characters are
         * letters, numbers, and underscore. The first character must be a lowercase letter.
         * </p>
         * 
         * @param id
         *        A short name used to tie this object to the results in the response. This name must be unique within a
         *        single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data,
         *        this name represents that data and can serve as a variable in the mathematical expression. The valid
         *        characters are letters, numbers, and underscore. The first character must be a lowercase letter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object
         * is retrieving a metric and not performing a math expression on returned data.
         * </p>
         * <p>
         * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
         * but not both.
         * </p>
         * 
         * @param metricStat
         *        The metric to be returned, along with statistics, period, and units. Use this parameter only if this
         *        object is retrieving a metric and not performing a math expression on returned data.</p>
         *        <p>
         *        Within one MetricDataQuery object, you must specify either <code>Expression</code> or
         *        <code>MetricStat</code> but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricStat(MetricStat metricStat);

        /**
         * <p>
         * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object
         * is retrieving a metric and not performing a math expression on returned data.
         * </p>
         * <p>
         * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
         * but not both.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricStat.Builder} avoiding the need to create
         * one manually via {@link MetricStat#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricStat.Builder#build()} is called immediately and its result
         * is passed to {@link #metricStat(MetricStat)}.
         * 
         * @param metricStat
         *        a consumer that will call methods on {@link MetricStat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricStat(MetricStat)
         */
        default Builder metricStat(Consumer<MetricStat.Builder> metricStat) {
            return metricStat(MetricStat.builder().applyMutation(metricStat).build());
        }

        /**
         * <p>
         * The math expression to be performed on the returned data, if this object is performing a math expression.
         * This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use
         * the <code>Id</code> of other expressions to use the result of those expressions. For more information about
         * metric math expressions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
         * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * <p>
         * Within each MetricDataQuery object, you must specify either <code>Expression</code> or
         * <code>MetricStat</code> but not both.
         * </p>
         * 
         * @param expression
         *        The math expression to be performed on the returned data, if this object is performing a math
         *        expression. This expression can use the <code>Id</code> of the other metrics to refer to those
         *        metrics, and can also use the <code>Id</code> of other expressions to use the result of those
         *        expressions. For more information about metric math expressions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
         *        >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
         *        <p>
         *        Within each MetricDataQuery object, you must specify either <code>Expression</code> or
         *        <code>MetricStat</code> but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A human-readable label for this metric or expression. This is especially useful if this is an expression, so
         * that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard
         * widget, the label is shown. If Label is omitted, CloudWatch generates a default.
         * </p>
         * 
         * @param label
         *        A human-readable label for this metric or expression. This is especially useful if this is an
         *        expression, so that you know what the value represents. If the metric or expression is shown in a
         *        CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
         * values of this metric. If you are performing this call just to do math expressions and do not also need the
         * raw data returned, you can specify <code>False</code>. If you omit this, the default of <code>True</code> is
         * used.
         * </p>
         * <p>
         * When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as
         * the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
         * <code>ReturnData</code> as False.
         * </p>
         * 
         * @param returnData
         *        When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and
         *        raw data values of this metric. If you are performing this call just to do math expressions and do not
         *        also need the raw data returned, you can specify <code>False</code>. If you omit this, the default of
         *        <code>True</code> is used.</p>
         *        <p>
         *        When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to
         *        use as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code>
         *        operation, specify <code>ReturnData</code> as False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnData(Boolean returnData);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
         * be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are
         * collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60.
         * High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
         * <code>StorageResolution of 1 second</code>.
         * </p>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
         *        period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution
         *        metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
         *        or any multiple of 60. High-resolution metrics are those metrics stored by a
         *        <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private MetricStat metricStat;

        private String expression;

        private String label;

        private Boolean returnData;

        private Integer period;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataQuery model) {
            id(model.id);
            metricStat(model.metricStat);
            expression(model.expression);
            label(model.label);
            returnData(model.returnData);
            period(model.period);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricStat.Builder getMetricStat() {
            return metricStat != null ? metricStat.toBuilder() : null;
        }

        @Override
        public final Builder metricStat(MetricStat metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        public final void setMetricStat(MetricStat.BuilderImpl metricStat) {
            this.metricStat = metricStat != null ? metricStat.build() : null;
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Boolean getReturnData() {
            return returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public MetricDataQuery build() {
            return new MetricDataQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
